// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the GetId action.
 */
class GetIdRequest private constructor(builder: Builder) {
    /**
     * A standard AWS account ID (9+ digits).
     */
    val accountId: kotlin.String? = builder.accountId
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    val identityPoolId: kotlin.String? = builder.identityPoolId
    /**
     * A set of optional name-value pairs that map provider names to provider tokens. The available provider names for `Logins` are as follows:
     * + Facebook: `graph.facebook.com`
     * + Amazon Cognito user pool: `cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID>`, for example, `cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789`.
     * + Google: `accounts.google.com`
     * + Amazon: `www.amazon.com`
     * + Twitter: `api.twitter.com`
     * + Digits: `www.digits.com`
     */
    val logins: Map<String, String>? = builder.logins

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.GetIdRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetIdRequest(")
        append("accountId=$accountId,")
        append("identityPoolId=$identityPoolId,")
        append("logins=$logins)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (logins?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetIdRequest

        if (accountId != other.accountId) return false
        if (identityPoolId != other.identityPoolId) return false
        if (logins != other.logins) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.GetIdRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A standard AWS account ID (9+ digits).
         */
        var accountId: kotlin.String? = null
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        var identityPoolId: kotlin.String? = null
        /**
         * A set of optional name-value pairs that map provider names to provider tokens. The available provider names for `Logins` are as follows:
         * + Facebook: `graph.facebook.com`
         * + Amazon Cognito user pool: `cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID>`, for example, `cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789`.
         * + Google: `accounts.google.com`
         * + Amazon: `www.amazon.com`
         * + Twitter: `api.twitter.com`
         * + Digits: `www.digits.com`
         */
        var logins: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.GetIdRequest) : this() {
            this.accountId = x.accountId
            this.identityPoolId = x.identityPoolId
            this.logins = x.logins
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.GetIdRequest = GetIdRequest(this)
    }
}
