// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the CreateIdentityPool action.
 */
class CreateIdentityPoolRequest private constructor(builder: Builder) {
    /**
     * Enables or disables the Basic (Classic) authentication flow. For more information, see [Identity Pools (Federated Identities) Authentication Flow](https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html) in the *Amazon Cognito Developer Guide*.
     */
    val allowClassicFlow: kotlin.Boolean? = builder.allowClassicFlow
    /**
     * TRUE if the identity pool supports unauthenticated logins.
     */
    val allowUnauthenticatedIdentities: kotlin.Boolean = builder.allowUnauthenticatedIdentities
    /**
     * An array of Amazon Cognito user pools and their client IDs.
     */
    val cognitoIdentityProviders: List<CognitoIdentityProvider>? = builder.cognitoIdentityProviders
    /**
     * The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the `DeveloperProviderName`, you can use letters as well as period (`.`), underscore (`_`), and dash (`-`).
     *
     * Once you have set a developer provider name, you cannot change it. Please take care in setting this parameter.
     */
    val developerProviderName: kotlin.String? = builder.developerProviderName
    /**
     * A string that you provide.
     */
    val identityPoolName: kotlin.String? = builder.identityPoolName
    /**
     * Tags to assign to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
     */
    val identityPoolTags: Map<String, String>? = builder.identityPoolTags
    /**
     * The Amazon Resource Names (ARN) of the OpenID Connect providers.
     */
    val openIdConnectProviderArNs: List<String>? = builder.openIdConnectProviderArNs
    /**
     * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
     */
    val samlProviderArNs: List<String>? = builder.samlProviderArNs
    /**
     * Optional key:value pairs mapping provider names to provider app IDs.
     */
    val supportedLoginProviders: Map<String, String>? = builder.supportedLoginProviders

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.CreateIdentityPoolRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIdentityPoolRequest(")
        append("allowClassicFlow=$allowClassicFlow,")
        append("allowUnauthenticatedIdentities=$allowUnauthenticatedIdentities,")
        append("cognitoIdentityProviders=$cognitoIdentityProviders,")
        append("developerProviderName=$developerProviderName,")
        append("identityPoolName=$identityPoolName,")
        append("identityPoolTags=$identityPoolTags,")
        append("openIdConnectProviderArNs=$openIdConnectProviderArNs,")
        append("samlProviderArNs=$samlProviderArNs,")
        append("supportedLoginProviders=$supportedLoginProviders)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowClassicFlow?.hashCode() ?: 0
        result = 31 * result + (allowUnauthenticatedIdentities.hashCode())
        result = 31 * result + (cognitoIdentityProviders?.hashCode() ?: 0)
        result = 31 * result + (developerProviderName?.hashCode() ?: 0)
        result = 31 * result + (identityPoolName?.hashCode() ?: 0)
        result = 31 * result + (identityPoolTags?.hashCode() ?: 0)
        result = 31 * result + (openIdConnectProviderArNs?.hashCode() ?: 0)
        result = 31 * result + (samlProviderArNs?.hashCode() ?: 0)
        result = 31 * result + (supportedLoginProviders?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIdentityPoolRequest

        if (allowClassicFlow != other.allowClassicFlow) return false
        if (allowUnauthenticatedIdentities != other.allowUnauthenticatedIdentities) return false
        if (cognitoIdentityProviders != other.cognitoIdentityProviders) return false
        if (developerProviderName != other.developerProviderName) return false
        if (identityPoolName != other.identityPoolName) return false
        if (identityPoolTags != other.identityPoolTags) return false
        if (openIdConnectProviderArNs != other.openIdConnectProviderArNs) return false
        if (samlProviderArNs != other.samlProviderArNs) return false
        if (supportedLoginProviders != other.supportedLoginProviders) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.CreateIdentityPoolRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Enables or disables the Basic (Classic) authentication flow. For more information, see [Identity Pools (Federated Identities) Authentication Flow](https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html) in the *Amazon Cognito Developer Guide*.
         */
        var allowClassicFlow: kotlin.Boolean? = null
        /**
         * TRUE if the identity pool supports unauthenticated logins.
         */
        var allowUnauthenticatedIdentities: kotlin.Boolean = false
        /**
         * An array of Amazon Cognito user pools and their client IDs.
         */
        var cognitoIdentityProviders: List<CognitoIdentityProvider>? = null
        /**
         * The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the `DeveloperProviderName`, you can use letters as well as period (`.`), underscore (`_`), and dash (`-`).
         *
         * Once you have set a developer provider name, you cannot change it. Please take care in setting this parameter.
         */
        var developerProviderName: kotlin.String? = null
        /**
         * A string that you provide.
         */
        var identityPoolName: kotlin.String? = null
        /**
         * Tags to assign to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
         */
        var identityPoolTags: Map<String, String>? = null
        /**
         * The Amazon Resource Names (ARN) of the OpenID Connect providers.
         */
        var openIdConnectProviderArNs: List<String>? = null
        /**
         * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
         */
        var samlProviderArNs: List<String>? = null
        /**
         * Optional key:value pairs mapping provider names to provider app IDs.
         */
        var supportedLoginProviders: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.CreateIdentityPoolRequest) : this() {
            this.allowClassicFlow = x.allowClassicFlow
            this.allowUnauthenticatedIdentities = x.allowUnauthenticatedIdentities
            this.cognitoIdentityProviders = x.cognitoIdentityProviders
            this.developerProviderName = x.developerProviderName
            this.identityPoolName = x.identityPoolName
            this.identityPoolTags = x.identityPoolTags
            this.openIdConnectProviderArNs = x.openIdConnectProviderArNs
            this.samlProviderArNs = x.samlProviderArNs
            this.supportedLoginProviders = x.supportedLoginProviders
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.CreateIdentityPoolRequest = CreateIdentityPoolRequest(this)
    }
}
