// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarconnections.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The VPC configuration provisioned for the host.
 */
public class VpcConfiguration private constructor(builder: Builder) {
    /**
     * The ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    public val securityGroupIds: List<String> = requireNotNull(builder.securityGroupIds) { "A non-null value must be provided for securityGroupIds" }
    /**
     * The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    public val subnetIds: List<String> = requireNotNull(builder.subnetIds) { "A non-null value must be provided for subnetIds" }
    /**
     * The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your provider type is installed.
     */
    public val tlsCertificate: kotlin.String? = builder.tlsCertificate
    /**
     * The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    public val vpcId: kotlin.String = requireNotNull(builder.vpcId) { "A non-null value must be provided for vpcId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codestarconnections.model.VpcConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConfiguration(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("tlsCertificate=$tlsCertificate,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds.hashCode()
        result = 31 * result + (subnetIds.hashCode())
        result = 31 * result + (tlsCertificate?.hashCode() ?: 0)
        result = 31 * result + (vpcId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConfiguration

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (tlsCertificate != other.tlsCertificate) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codestarconnections.model.VpcConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
         */
        public var subnetIds: List<String>? = null
        /**
         * The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your provider type is installed.
         */
        public var tlsCertificate: kotlin.String? = null
        /**
         * The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codestarconnections.model.VpcConfiguration) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.tlsCertificate = x.tlsCertificate
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codestarconnections.model.VpcConfiguration = VpcConfiguration(this)

        internal fun correctErrors(): Builder {
            if (securityGroupIds == null) securityGroupIds = emptyList()
            if (subnetIds == null) subnetIds = emptyList()
            if (vpcId == null) vpcId = ""
            return this
        }
    }
}
