// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarconnections.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a repository sync attempt for a repository with a sync configuration.
 */
public class RepositorySyncAttempt private constructor(builder: Builder) {
    /**
     * The events associated with a specific sync attempt.
     */
    public val events: List<RepositorySyncEvent> = requireNotNull(builder.events) { "A non-null value must be provided for events" }
    /**
     * The start time of a specific sync attempt.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startedAt) { "A non-null value must be provided for startedAt" }
    /**
     * The status of a specific sync attempt. The following are valid statuses:
     * + INITIATED - A repository sync attempt has been created and will begin soon.
     * + IN_PROGRESS - A repository sync attempt has started and work is being done to reconcile the branch.
     * + SUCCEEDED - The repository sync attempt has completed successfully.
     * + FAILED - The repository sync attempt has failed.
     * + QUEUED - The repository sync attempt didn't execute and was queued.
     */
    public val status: aws.sdk.kotlin.services.codestarconnections.model.RepositorySyncStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codestarconnections.model.RepositorySyncAttempt = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositorySyncAttempt(")
        append("events=$events,")
        append("startedAt=$startedAt,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = events.hashCode()
        result = 31 * result + (startedAt.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositorySyncAttempt

        if (events != other.events) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codestarconnections.model.RepositorySyncAttempt = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The events associated with a specific sync attempt.
         */
        public var events: List<RepositorySyncEvent>? = null
        /**
         * The start time of a specific sync attempt.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of a specific sync attempt. The following are valid statuses:
         * + INITIATED - A repository sync attempt has been created and will begin soon.
         * + IN_PROGRESS - A repository sync attempt has started and work is being done to reconcile the branch.
         * + SUCCEEDED - The repository sync attempt has completed successfully.
         * + FAILED - The repository sync attempt has failed.
         * + QUEUED - The repository sync attempt didn't execute and was queued.
         */
        public var status: aws.sdk.kotlin.services.codestarconnections.model.RepositorySyncStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codestarconnections.model.RepositorySyncAttempt) : this() {
            this.events = x.events
            this.startedAt = x.startedAt
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codestarconnections.model.RepositorySyncAttempt = RepositorySyncAttempt(this)

        internal fun correctErrors(): Builder {
            if (events == null) events = emptyList()
            if (startedAt == null) startedAt = Instant.fromEpochSeconds(0)
            if (status == null) status = RepositorySyncStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
