// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarconnections.paginators

import aws.sdk.kotlin.services.codestarconnections.CodeStarConnectionsClient
import aws.sdk.kotlin.services.codestarconnections.model.ListConnectionsRequest
import aws.sdk.kotlin.services.codestarconnections.model.ListConnectionsResponse
import aws.sdk.kotlin.services.codestarconnections.model.ListHostsRequest
import aws.sdk.kotlin.services.codestarconnections.model.ListHostsResponse
import aws.sdk.kotlin.services.codestarconnections.model.ListRepositoryLinksRequest
import aws.sdk.kotlin.services.codestarconnections.model.ListRepositoryLinksResponse
import aws.sdk.kotlin.services.codestarconnections.model.ListSyncConfigurationsRequest
import aws.sdk.kotlin.services.codestarconnections.model.ListSyncConfigurationsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConnectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectionsResponse]
 */
public fun CodeStarConnectionsClient.listConnectionsPaginated(initialRequest: ListConnectionsRequest = ListConnectionsRequest { }): Flow<ListConnectionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConnectionsPaginated.listConnections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectionsResponse]
 */
public fun CodeStarConnectionsClient.listConnectionsPaginated(block: ListConnectionsRequest.Builder.() -> Unit): Flow<ListConnectionsResponse> =
    listConnectionsPaginated(ListConnectionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListHostsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListHostsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHostsResponse]
 */
public fun CodeStarConnectionsClient.listHostsPaginated(initialRequest: ListHostsRequest = ListHostsRequest { }): Flow<ListHostsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listHostsPaginated.listHosts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListHostsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHostsResponse]
 */
public fun CodeStarConnectionsClient.listHostsPaginated(block: ListHostsRequest.Builder.() -> Unit): Flow<ListHostsResponse> =
    listHostsPaginated(ListHostsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRepositoryLinksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRepositoryLinksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoryLinksResponse]
 */
public fun CodeStarConnectionsClient.listRepositoryLinksPaginated(initialRequest: ListRepositoryLinksRequest = ListRepositoryLinksRequest { }): Flow<ListRepositoryLinksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRepositoryLinksPaginated.listRepositoryLinks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRepositoryLinksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoryLinksResponse]
 */
public fun CodeStarConnectionsClient.listRepositoryLinksPaginated(block: ListRepositoryLinksRequest.Builder.() -> Unit): Flow<ListRepositoryLinksResponse> =
    listRepositoryLinksPaginated(ListRepositoryLinksRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSyncConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSyncConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSyncConfigurationsResponse]
 */
public fun CodeStarConnectionsClient.listSyncConfigurationsPaginated(initialRequest: ListSyncConfigurationsRequest): Flow<ListSyncConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSyncConfigurationsPaginated.listSyncConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSyncConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSyncConfigurationsResponse]
 */
public fun CodeStarConnectionsClient.listSyncConfigurationsPaginated(block: ListSyncConfigurationsRequest.Builder.() -> Unit): Flow<ListSyncConfigurationsResponse> =
    listSyncConfigurationsPaginated(ListSyncConfigurationsRequest.Builder().apply(block).build())
