// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarconnections.serde

import aws.sdk.kotlin.services.codestarconnections.model.CodeStarConnectionsException
import aws.sdk.kotlin.services.codestarconnections.model.GetHostResponse
import aws.sdk.kotlin.services.codestarconnections.model.ProviderType
import aws.sdk.kotlin.services.codestarconnections.model.VpcConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetHostOperationDeserializer: HttpDeserialize<GetHostResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetHostResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetHostError(context, call)
        }
        val builder = GetHostResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetHostOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetHostError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeStarConnectionsException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceUnavailableException" -> ResourceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeStarConnectionsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetHostOperationBody(builder: GetHostResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PROVIDERENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProviderEndpoint"))
    val PROVIDERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ProviderType"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val VPCCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NAME_DESCRIPTOR)
        field(PROVIDERENDPOINT_DESCRIPTOR)
        field(PROVIDERTYPE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(VPCCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PROVIDERENDPOINT_DESCRIPTOR.index -> builder.providerEndpoint = deserializeString()
                PROVIDERTYPE_DESCRIPTOR.index -> builder.providerType = deserializeString().let { ProviderType.fromValue(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                VPCCONFIGURATION_DESCRIPTOR.index -> builder.vpcConfiguration = deserializeVpcConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
