// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarconnections

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.codestarconnections.auth.CodeStarConnectionsAuthSchemeProvider
import aws.sdk.kotlin.services.codestarconnections.auth.DefaultCodeStarConnectionsAuthSchemeProvider
import aws.sdk.kotlin.services.codestarconnections.endpoints.CodeStarConnectionsEndpointParameters
import aws.sdk.kotlin.services.codestarconnections.endpoints.CodeStarConnectionsEndpointProvider
import aws.sdk.kotlin.services.codestarconnections.endpoints.DefaultCodeStarConnectionsEndpointProvider
import aws.sdk.kotlin.services.codestarconnections.model.CreateConnectionRequest
import aws.sdk.kotlin.services.codestarconnections.model.CreateConnectionResponse
import aws.sdk.kotlin.services.codestarconnections.model.CreateHostRequest
import aws.sdk.kotlin.services.codestarconnections.model.CreateHostResponse
import aws.sdk.kotlin.services.codestarconnections.model.DeleteConnectionRequest
import aws.sdk.kotlin.services.codestarconnections.model.DeleteConnectionResponse
import aws.sdk.kotlin.services.codestarconnections.model.DeleteHostRequest
import aws.sdk.kotlin.services.codestarconnections.model.DeleteHostResponse
import aws.sdk.kotlin.services.codestarconnections.model.GetConnectionRequest
import aws.sdk.kotlin.services.codestarconnections.model.GetConnectionResponse
import aws.sdk.kotlin.services.codestarconnections.model.GetHostRequest
import aws.sdk.kotlin.services.codestarconnections.model.GetHostResponse
import aws.sdk.kotlin.services.codestarconnections.model.ListConnectionsRequest
import aws.sdk.kotlin.services.codestarconnections.model.ListConnectionsResponse
import aws.sdk.kotlin.services.codestarconnections.model.ListHostsRequest
import aws.sdk.kotlin.services.codestarconnections.model.ListHostsResponse
import aws.sdk.kotlin.services.codestarconnections.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.codestarconnections.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.codestarconnections.model.TagResourceRequest
import aws.sdk.kotlin.services.codestarconnections.model.TagResourceResponse
import aws.sdk.kotlin.services.codestarconnections.model.UntagResourceRequest
import aws.sdk.kotlin.services.codestarconnections.model.UntagResourceResponse
import aws.sdk.kotlin.services.codestarconnections.model.UpdateHostRequest
import aws.sdk.kotlin.services.codestarconnections.model.UpdateHostResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "CodeStar connections"
public const val SdkVersion: String = "0.34.9-beta"

/**
 * # AWS CodeStar Connections
 * This Amazon Web Services CodeStar Connections API Reference provides descriptions and usage examples of the operations and data types for the Amazon Web Services CodeStar Connections API. You can use the connections API to work with connections and installations.
 *
 * *Connections* are configurations that you use to connect Amazon Web Services resources to external code repositories. Each connection is a resource that can be given to services such as CodePipeline to connect to a third-party repository such as Bitbucket. For example, you can add the connection in CodePipeline so that it triggers your pipeline when a code change is made to your third-party code repository. Each connection is named and associated with a unique ARN that is used to reference the connection.
 *
 * When you create a connection, the console initiates a third-party connection handshake. *Installations* are the apps that are used to conduct this handshake. For example, the installation for the Bitbucket provider type is the Bitbucket app. When you create a connection, you can choose an existing installation or create one.
 *
 * When you want to create a connection to an installed provider type such as GitHub Enterprise Server, you create a *host* for your connections.
 *
 * You can work with connections by calling:
 * + CreateConnection, which creates a uniquely named connection that can be referenced by services such as CodePipeline.
 * + DeleteConnection, which deletes the specified connection.
 * + GetConnection, which returns information about the connection, including the connection status.
 * + ListConnections, which lists the connections associated with your account.
 *
 * You can work with hosts by calling:
 * + CreateHost, which creates a host that represents the infrastructure where your provider is installed.
 * + DeleteHost, which deletes the specified host.
 * + GetHost, which returns information about the host, including the setup status.
 * + ListHosts, which lists the hosts associated with your account.
 *
 * You can work with tags in Amazon Web Services CodeStar Connections by calling the following:
 * + ListTagsForResource, which gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in Amazon Web Services CodeStar Connections.
 * + TagResource, which adds or updates tags for a resource in Amazon Web Services CodeStar Connections.
 * + UntagResource, which removes tags for a resource in Amazon Web Services CodeStar Connections.
 *
 * For information about how to use Amazon Web Services CodeStar Connections, see the [Developer Tools User Guide](https://docs.aws.amazon.com/dtconsole/latest/userguide/welcome-connections.html).
 */
public interface CodeStarConnectionsClient : SdkClient {
    /**
     * CodeStarConnectionsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CodeStarConnectionsClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>) {
            builder.config.interceptors.add(0, ClockSkewInterceptor())
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CodeStarConnections",
                "CODESTAR_CONNECTIONS",
                "codestar_connections",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CodeStarConnectionsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CodeStarConnectionsClient = DefaultCodeStarConnectionsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CodeStarConnectionsEndpointProvider = builder.endpointProvider ?: DefaultCodeStarConnectionsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CodeStarConnectionsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCodeStarConnectionsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CodeStar connections"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CodeStarConnectionsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CodeStarConnectionsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a connection that can then be given to other Amazon Web Services services like CodePipeline so that it can access third-party code repositories. The connection is in pending status until the third-party connection handshake is completed from the console.
     */
    public suspend fun createConnection(input: CreateConnectionRequest): CreateConnectionResponse

    /**
     * Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.
     *
     * A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE` by setting up the host in the console.
     */
    public suspend fun createHost(input: CreateHostRequest): CreateHostResponse

    /**
     * The connection to be deleted.
     */
    public suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse

    /**
     * The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.
     *
     * A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING state.
     */
    public suspend fun deleteHost(input: DeleteHostRequest): DeleteHostResponse

    /**
     * Returns the connection ARN and details such as status, owner, and provider type.
     */
    public suspend fun getConnection(input: GetConnectionRequest): GetConnectionResponse

    /**
     * Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC configuration.
     */
    public suspend fun getHost(input: GetHostRequest): GetHostResponse

    /**
     * Lists the connections associated with your account.
     */
    public suspend fun listConnections(input: ListConnectionsRequest = ListConnectionsRequest { }): ListConnectionsResponse

    /**
     * Lists the hosts associated with your account.
     */
    public suspend fun listHosts(input: ListHostsRequest = ListHostsRequest { }): ListHostsResponse

    /**
     * Gets the set of key-value pairs (metadata) that are used to manage the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from an Amazon Web Services resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a specified host with the provided configurations.
     */
    public suspend fun updateHost(input: UpdateHostRequest): UpdateHostResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CodeStarConnectionsClient.withConfig(block: CodeStarConnectionsClient.Config.Builder.() -> Unit): CodeStarConnectionsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCodeStarConnectionsClient(newConfig)
}

/**
 * Creates a connection that can then be given to other Amazon Web Services services like CodePipeline so that it can access third-party code repositories. The connection is in pending status until the third-party connection handshake is completed from the console.
 */
public suspend inline fun CodeStarConnectionsClient.createConnection(crossinline block: CreateConnectionRequest.Builder.() -> Unit): CreateConnectionResponse = createConnection(CreateConnectionRequest.Builder().apply(block).build())

/**
 * Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.
 *
 * A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE` by setting up the host in the console.
 */
public suspend inline fun CodeStarConnectionsClient.createHost(crossinline block: CreateHostRequest.Builder.() -> Unit): CreateHostResponse = createHost(CreateHostRequest.Builder().apply(block).build())

/**
 * The connection to be deleted.
 */
public suspend inline fun CodeStarConnectionsClient.deleteConnection(crossinline block: DeleteConnectionRequest.Builder.() -> Unit): DeleteConnectionResponse = deleteConnection(DeleteConnectionRequest.Builder().apply(block).build())

/**
 * The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.
 *
 * A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING state.
 */
public suspend inline fun CodeStarConnectionsClient.deleteHost(crossinline block: DeleteHostRequest.Builder.() -> Unit): DeleteHostResponse = deleteHost(DeleteHostRequest.Builder().apply(block).build())

/**
 * Returns the connection ARN and details such as status, owner, and provider type.
 */
public suspend inline fun CodeStarConnectionsClient.getConnection(crossinline block: GetConnectionRequest.Builder.() -> Unit): GetConnectionResponse = getConnection(GetConnectionRequest.Builder().apply(block).build())

/**
 * Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC configuration.
 */
public suspend inline fun CodeStarConnectionsClient.getHost(crossinline block: GetHostRequest.Builder.() -> Unit): GetHostResponse = getHost(GetHostRequest.Builder().apply(block).build())

/**
 * Lists the connections associated with your account.
 */
public suspend inline fun CodeStarConnectionsClient.listConnections(crossinline block: ListConnectionsRequest.Builder.() -> Unit): ListConnectionsResponse = listConnections(ListConnectionsRequest.Builder().apply(block).build())

/**
 * Lists the hosts associated with your account.
 */
public suspend inline fun CodeStarConnectionsClient.listHosts(crossinline block: ListHostsRequest.Builder.() -> Unit): ListHostsResponse = listHosts(ListHostsRequest.Builder().apply(block).build())

/**
 * Gets the set of key-value pairs (metadata) that are used to manage the resource.
 */
public suspend inline fun CodeStarConnectionsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
 */
public suspend inline fun CodeStarConnectionsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from an Amazon Web Services resource.
 */
public suspend inline fun CodeStarConnectionsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a specified host with the provided configurations.
 */
public suspend inline fun CodeStarConnectionsClient.updateHost(crossinline block: UpdateHostRequest.Builder.() -> Unit): UpdateHostResponse = updateHost(UpdateHostRequest.Builder().apply(block).build())
