// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar.model



/**
 * Location and destination information about the source code files provided with the project request. The source code is uploaded to the new project source repository after project creation.
 */
public class Code private constructor(builder: Builder) {
    /**
     * The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS CodeStar provisions the new repository, the source code files provided with the project request are placed in the repository.
     */
    public val destination: aws.sdk.kotlin.services.codestar.model.CodeDestination? = builder.destination
    /**
     * The location where the source code files provided with the project request are stored. AWS CodeStar retrieves the files during project creation.
     */
    public val source: aws.sdk.kotlin.services.codestar.model.CodeSource? = builder.source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codestar.model.Code = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Code(")
        append("destination=$destination,")
        append("source=$source")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Code

        if (destination != other.destination) return false
        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codestar.model.Code = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS CodeStar provisions the new repository, the source code files provided with the project request are placed in the repository.
         */
        public var destination: aws.sdk.kotlin.services.codestar.model.CodeDestination? = null
        /**
         * The location where the source code files provided with the project request are stored. AWS CodeStar retrieves the files during project creation.
         */
        public var source: aws.sdk.kotlin.services.codestar.model.CodeSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codestar.model.Code) : this() {
            this.destination = x.destination
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codestar.model.Code = Code(this)

        /**
         * construct an [aws.sdk.kotlin.services.codestar.model.CodeDestination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.codestar.model.CodeDestination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.codestar.model.CodeDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codestar.model.CodeSource] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.codestar.model.CodeSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.codestar.model.CodeSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (destination == null) destination = CodeDestination.Builder().correctErrors().build()
            if (source == null) source = CodeSource.Builder().correctErrors().build()
            return this
        }
    }
}
