// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar.model



/**
 * The toolchain template file provided with the project request. AWS CodeStar uses the template to provision the toolchain stack in AWS CloudFormation.
 */
class Toolchain private constructor(builder: Builder) {
    /**
     * The service role ARN for AWS CodeStar to use for the toolchain template during stack provisioning.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon S3 location where the toolchain template file provided with the project request is stored. AWS CodeStar retrieves the file during project creation.
     */
    val source: aws.sdk.kotlin.services.codestar.model.ToolchainSource? = builder.source
    /**
     * The list of parameter overrides to be passed into the toolchain template during stack provisioning, if any.
     */
    val stackParameters: Map<String, String>? = builder.stackParameters

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codestar.model.Toolchain = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Toolchain(")
        append("roleArn=$roleArn,")
        append("source=$source,")
        append("stackParameters=$stackParameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (stackParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Toolchain

        if (roleArn != other.roleArn) return false
        if (source != other.source) return false
        if (stackParameters != other.stackParameters) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codestar.model.Toolchain = Builder(this).apply(block).build()

    class Builder {
        /**
         * The service role ARN for AWS CodeStar to use for the toolchain template during stack provisioning.
         */
        var roleArn: kotlin.String? = null
        /**
         * The Amazon S3 location where the toolchain template file provided with the project request is stored. AWS CodeStar retrieves the file during project creation.
         */
        var source: aws.sdk.kotlin.services.codestar.model.ToolchainSource? = null
        /**
         * The list of parameter overrides to be passed into the toolchain template during stack provisioning, if any.
         */
        var stackParameters: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codestar.model.Toolchain) : this() {
            this.roleArn = x.roleArn
            this.source = x.source
            this.stackParameters = x.stackParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codestar.model.Toolchain = Toolchain(this)

        /**
         * construct an [aws.sdk.kotlin.services.codestar.model.ToolchainSource] inside the given [block]
         */
        fun source(block: aws.sdk.kotlin.services.codestar.model.ToolchainSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.codestar.model.ToolchainSource.invoke(block)
        }
    }
}
