// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar.model



/**
 * The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS CodeStar provisions the new repository, the source code files provided with the project request are placed in the repository.
 */
class CodeDestination private constructor(builder: Builder) {
    /**
     * Information about the AWS CodeCommit repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.
     */
    val codeCommit: aws.sdk.kotlin.services.codestar.model.CodeCommitCodeDestination? = builder.codeCommit
    /**
     * Information about the GitHub repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.
     */
    val gitHub: aws.sdk.kotlin.services.codestar.model.GitHubCodeDestination? = builder.gitHub

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codestar.model.CodeDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeDestination(")
        append("codeCommit=$codeCommit,")
        append("gitHub=$gitHub)")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeCommit?.hashCode() ?: 0
        result = 31 * result + (gitHub?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeDestination

        if (codeCommit != other.codeCommit) return false
        if (gitHub != other.gitHub) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codestar.model.CodeDestination = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about the AWS CodeCommit repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.
         */
        var codeCommit: aws.sdk.kotlin.services.codestar.model.CodeCommitCodeDestination? = null
        /**
         * Information about the GitHub repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.
         */
        var gitHub: aws.sdk.kotlin.services.codestar.model.GitHubCodeDestination? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codestar.model.CodeDestination) : this() {
            this.codeCommit = x.codeCommit
            this.gitHub = x.gitHub
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codestar.model.CodeDestination = CodeDestination(this)

        /**
         * construct an [aws.sdk.kotlin.services.codestar.model.CodeCommitCodeDestination] inside the given [block]
         */
        fun codeCommit(block: aws.sdk.kotlin.services.codestar.model.CodeCommitCodeDestination.Builder.() -> kotlin.Unit) {
            this.codeCommit = aws.sdk.kotlin.services.codestar.model.CodeCommitCodeDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codestar.model.GitHubCodeDestination] inside the given [block]
         */
        fun gitHub(block: aws.sdk.kotlin.services.codestar.model.GitHubCodeDestination.Builder.() -> kotlin.Unit) {
            this.gitHub = aws.sdk.kotlin.services.codestar.model.GitHubCodeDestination.invoke(block)
        }
    }
}
