// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateProjectRequest private constructor(builder: Builder) {
    /**
     * A user- or system-generated token that identifies the entity that requested project creation. This token can be used to repeat the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The description of the project, if any.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the project to be created in AWS CodeStar.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The display name for the project to be created in AWS CodeStar.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of the Code objects submitted with the project request. If this parameter is specified, the request must also include the toolchain parameter.
     */
    public val sourceCode: List<Code>? = builder.sourceCode
    /**
     * The tags created for the project.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The name of the toolchain template file submitted with the project request. If this parameter is specified, the request must also include the sourceCode parameter.
     */
    public val toolchain: aws.sdk.kotlin.services.codestar.model.Toolchain? = builder.toolchain

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codestar.model.CreateProjectRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProjectRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("description=*** Sensitive Data Redacted ***,")
        append("id=$id,")
        append("name=*** Sensitive Data Redacted ***,")
        append("sourceCode=$sourceCode,")
        append("tags=$tags,")
        append("toolchain=$toolchain")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sourceCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (toolchain?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateProjectRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (sourceCode != other.sourceCode) return false
        if (tags != other.tags) return false
        if (toolchain != other.toolchain) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codestar.model.CreateProjectRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A user- or system-generated token that identifies the entity that requested project creation. This token can be used to repeat the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The description of the project, if any.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the project to be created in AWS CodeStar.
         */
        public var id: kotlin.String? = null
        /**
         * The display name for the project to be created in AWS CodeStar.
         */
        public var name: kotlin.String? = null
        /**
         * A list of the Code objects submitted with the project request. If this parameter is specified, the request must also include the toolchain parameter.
         */
        public var sourceCode: List<Code>? = null
        /**
         * The tags created for the project.
         */
        public var tags: Map<String, String>? = null
        /**
         * The name of the toolchain template file submitted with the project request. If this parameter is specified, the request must also include the sourceCode parameter.
         */
        public var toolchain: aws.sdk.kotlin.services.codestar.model.Toolchain? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codestar.model.CreateProjectRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.sourceCode = x.sourceCode
            this.tags = x.tags
            this.toolchain = x.toolchain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codestar.model.CreateProjectRequest = CreateProjectRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codestar.model.Toolchain] inside the given [block]
         */
        public fun toolchain(block: aws.sdk.kotlin.services.codestar.model.Toolchain.Builder.() -> kotlin.Unit) {
            this.toolchain = aws.sdk.kotlin.services.codestar.model.Toolchain.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
