// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.codestar.auth.CodeStarAuthSchemeProvider
import aws.sdk.kotlin.services.codestar.auth.DefaultCodeStarAuthSchemeProvider
import aws.sdk.kotlin.services.codestar.endpoints.CodeStarEndpointParameters
import aws.sdk.kotlin.services.codestar.endpoints.CodeStarEndpointProvider
import aws.sdk.kotlin.services.codestar.endpoints.DefaultCodeStarEndpointProvider
import aws.sdk.kotlin.services.codestar.model.AssociateTeamMemberRequest
import aws.sdk.kotlin.services.codestar.model.AssociateTeamMemberResponse
import aws.sdk.kotlin.services.codestar.model.CreateProjectRequest
import aws.sdk.kotlin.services.codestar.model.CreateProjectResponse
import aws.sdk.kotlin.services.codestar.model.CreateUserProfileRequest
import aws.sdk.kotlin.services.codestar.model.CreateUserProfileResponse
import aws.sdk.kotlin.services.codestar.model.DeleteProjectRequest
import aws.sdk.kotlin.services.codestar.model.DeleteProjectResponse
import aws.sdk.kotlin.services.codestar.model.DeleteUserProfileRequest
import aws.sdk.kotlin.services.codestar.model.DeleteUserProfileResponse
import aws.sdk.kotlin.services.codestar.model.DescribeProjectRequest
import aws.sdk.kotlin.services.codestar.model.DescribeProjectResponse
import aws.sdk.kotlin.services.codestar.model.DescribeUserProfileRequest
import aws.sdk.kotlin.services.codestar.model.DescribeUserProfileResponse
import aws.sdk.kotlin.services.codestar.model.DisassociateTeamMemberRequest
import aws.sdk.kotlin.services.codestar.model.DisassociateTeamMemberResponse
import aws.sdk.kotlin.services.codestar.model.ListProjectsRequest
import aws.sdk.kotlin.services.codestar.model.ListProjectsResponse
import aws.sdk.kotlin.services.codestar.model.ListResourcesRequest
import aws.sdk.kotlin.services.codestar.model.ListResourcesResponse
import aws.sdk.kotlin.services.codestar.model.ListTagsForProjectRequest
import aws.sdk.kotlin.services.codestar.model.ListTagsForProjectResponse
import aws.sdk.kotlin.services.codestar.model.ListTeamMembersRequest
import aws.sdk.kotlin.services.codestar.model.ListTeamMembersResponse
import aws.sdk.kotlin.services.codestar.model.ListUserProfilesRequest
import aws.sdk.kotlin.services.codestar.model.ListUserProfilesResponse
import aws.sdk.kotlin.services.codestar.model.TagProjectRequest
import aws.sdk.kotlin.services.codestar.model.TagProjectResponse
import aws.sdk.kotlin.services.codestar.model.UntagProjectRequest
import aws.sdk.kotlin.services.codestar.model.UntagProjectResponse
import aws.sdk.kotlin.services.codestar.model.UpdateProjectRequest
import aws.sdk.kotlin.services.codestar.model.UpdateProjectResponse
import aws.sdk.kotlin.services.codestar.model.UpdateTeamMemberRequest
import aws.sdk.kotlin.services.codestar.model.UpdateTeamMemberResponse
import aws.sdk.kotlin.services.codestar.model.UpdateUserProfileRequest
import aws.sdk.kotlin.services.codestar.model.UpdateUserProfileResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "CodeStar"
public const val SdkVersion: String = "1.0.2"

/**
 * # AWS CodeStar
 * This is the API reference for AWS CodeStar. This reference provides descriptions of the operations and data types for the AWS CodeStar API along with usage examples.
 *
 * You can use the AWS CodeStar API to work with:
 *
 * Projects and their resources, by calling the following:
 * + `DeleteProject`, which deletes a project.
 * + `DescribeProject`, which lists the attributes of a project.
 * + `ListProjects`, which lists all projects associated with your AWS account.
 * + `ListResources`, which lists the resources associated with a project.
 * + `ListTagsForProject`, which lists the tags associated with a project.
 * + `TagProject`, which adds tags to a project.
 * + `UntagProject`, which removes tags from a project.
 * + `UpdateProject`, which updates the attributes of a project.
 *
 * Teams and team members, by calling the following:
 * + `AssociateTeamMember`, which adds an IAM user to the team for a project.
 * + `DisassociateTeamMember`, which removes an IAM user from the team for a project.
 * + `ListTeamMembers`, which lists all the IAM users in the team for a project, including their roles and attributes.
 * + `UpdateTeamMember`, which updates a team member's attributes in a project.
 *
 * Users, by calling the following:
 * + `CreateUserProfile`, which creates a user profile that contains data associated with the user across all projects.
 * + `DeleteUserProfile`, which deletes all user profile information across all projects.
 * + `DescribeUserProfile`, which describes the profile of a user.
 * + `ListUserProfiles`, which lists all user profiles.
 * + `UpdateUserProfile`, which updates the profile for a user.
 */
public interface CodeStarClient : SdkClient {
    /**
     * CodeStarClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CodeStarClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CodeStar",
                "CODESTAR",
                "codestar",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CodeStarClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CodeStarClient = DefaultCodeStarClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CodeStarEndpointProvider = builder.endpointProvider ?: DefaultCodeStarEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CodeStarAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCodeStarAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CodeStar"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CodeStarEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CodeStarAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds an IAM user to the team for an AWS CodeStar project.
     */
    public suspend fun associateTeamMember(input: AssociateTeamMemberRequest): AssociateTeamMemberResponse

    /**
     * Creates a project, including project resources. This action creates a project based on a submitted project request. A set of source code files and a toolchain template file can be included with the project request. If these are not provided, an empty project is created.
     */
    public suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Creates a profile for a user that includes user preferences, such as the display name and email address assocciated with the user, in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.
     */
    public suspend fun createUserProfile(input: CreateUserProfileRequest): CreateUserProfileResponse

    /**
     * Deletes a project, including project resources. Does not delete users associated with the project, but does delete the IAM roles that allowed access to the project.
     */
    public suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Deletes a user profile in AWS CodeStar, including all personal preference data associated with that profile, such as display name and email address. It does not delete the history of that user, for example the history of commits made by that user.
     */
    public suspend fun deleteUserProfile(input: DeleteUserProfileRequest): DeleteUserProfileResponse

    /**
     * Describes a project and its resources.
     */
    public suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Describes a user in AWS CodeStar and the user attributes across all projects.
     */
    public suspend fun describeUserProfile(input: DescribeUserProfileRequest): DescribeUserProfileResponse

    /**
     * Removes a user from a project. Removing a user from a project also removes the IAM policies from that user that allowed access to the project and its resources. Disassociating a team member does not remove that user's profile from AWS CodeStar. It does not remove the user from IAM.
     */
    public suspend fun disassociateTeamMember(input: DisassociateTeamMemberRequest): DisassociateTeamMemberResponse

    /**
     * Lists all projects in AWS CodeStar associated with your AWS account.
     */
    public suspend fun listProjects(input: ListProjectsRequest = ListProjectsRequest { }): ListProjectsResponse

    /**
     * Lists resources associated with a project in AWS CodeStar.
     */
    public suspend fun listResources(input: ListResourcesRequest): ListResourcesResponse

    /**
     * Gets the tags for a project.
     */
    public suspend fun listTagsForProject(input: ListTagsForProjectRequest): ListTagsForProjectResponse

    /**
     * Lists all team members associated with a project.
     */
    public suspend fun listTeamMembers(input: ListTeamMembersRequest): ListTeamMembersResponse

    /**
     * Lists all the user profiles configured for your AWS account in AWS CodeStar.
     */
    public suspend fun listUserProfiles(input: ListUserProfilesRequest = ListUserProfilesRequest { }): ListUserProfilesResponse

    /**
     * Adds tags to a project.
     */
    public suspend fun tagProject(input: TagProjectRequest): TagProjectResponse

    /**
     * Removes tags from a project.
     */
    public suspend fun untagProject(input: UntagProjectRequest): UntagProjectResponse

    /**
     * Updates a project in AWS CodeStar.
     */
    public suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse

    /**
     * Updates a team member's attributes in an AWS CodeStar project. For example, you can change a team member's role in the project, or change whether they have remote access to project resources.
     */
    public suspend fun updateTeamMember(input: UpdateTeamMemberRequest): UpdateTeamMemberResponse

    /**
     * Updates a user's profile in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.
     */
    public suspend fun updateUserProfile(input: UpdateUserProfileRequest): UpdateUserProfileResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CodeStarClient.withConfig(block: CodeStarClient.Config.Builder.() -> Unit): CodeStarClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCodeStarClient(newConfig)
}

/**
 * Adds an IAM user to the team for an AWS CodeStar project.
 */
public suspend inline fun CodeStarClient.associateTeamMember(crossinline block: AssociateTeamMemberRequest.Builder.() -> Unit): AssociateTeamMemberResponse = associateTeamMember(AssociateTeamMemberRequest.Builder().apply(block).build())

/**
 * Creates a project, including project resources. This action creates a project based on a submitted project request. A set of source code files and a toolchain template file can be included with the project request. If these are not provided, an empty project is created.
 */
public suspend inline fun CodeStarClient.createProject(crossinline block: CreateProjectRequest.Builder.() -> Unit): CreateProjectResponse = createProject(CreateProjectRequest.Builder().apply(block).build())

/**
 * Creates a profile for a user that includes user preferences, such as the display name and email address assocciated with the user, in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.
 */
public suspend inline fun CodeStarClient.createUserProfile(crossinline block: CreateUserProfileRequest.Builder.() -> Unit): CreateUserProfileResponse = createUserProfile(CreateUserProfileRequest.Builder().apply(block).build())

/**
 * Deletes a project, including project resources. Does not delete users associated with the project, but does delete the IAM roles that allowed access to the project.
 */
public suspend inline fun CodeStarClient.deleteProject(crossinline block: DeleteProjectRequest.Builder.() -> Unit): DeleteProjectResponse = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

/**
 * Deletes a user profile in AWS CodeStar, including all personal preference data associated with that profile, such as display name and email address. It does not delete the history of that user, for example the history of commits made by that user.
 */
public suspend inline fun CodeStarClient.deleteUserProfile(crossinline block: DeleteUserProfileRequest.Builder.() -> Unit): DeleteUserProfileResponse = deleteUserProfile(DeleteUserProfileRequest.Builder().apply(block).build())

/**
 * Describes a project and its resources.
 */
public suspend inline fun CodeStarClient.describeProject(crossinline block: DescribeProjectRequest.Builder.() -> Unit): DescribeProjectResponse = describeProject(DescribeProjectRequest.Builder().apply(block).build())

/**
 * Describes a user in AWS CodeStar and the user attributes across all projects.
 */
public suspend inline fun CodeStarClient.describeUserProfile(crossinline block: DescribeUserProfileRequest.Builder.() -> Unit): DescribeUserProfileResponse = describeUserProfile(DescribeUserProfileRequest.Builder().apply(block).build())

/**
 * Removes a user from a project. Removing a user from a project also removes the IAM policies from that user that allowed access to the project and its resources. Disassociating a team member does not remove that user's profile from AWS CodeStar. It does not remove the user from IAM.
 */
public suspend inline fun CodeStarClient.disassociateTeamMember(crossinline block: DisassociateTeamMemberRequest.Builder.() -> Unit): DisassociateTeamMemberResponse = disassociateTeamMember(DisassociateTeamMemberRequest.Builder().apply(block).build())

/**
 * Lists all projects in AWS CodeStar associated with your AWS account.
 */
public suspend inline fun CodeStarClient.listProjects(crossinline block: ListProjectsRequest.Builder.() -> Unit): ListProjectsResponse = listProjects(ListProjectsRequest.Builder().apply(block).build())

/**
 * Lists resources associated with a project in AWS CodeStar.
 */
public suspend inline fun CodeStarClient.listResources(crossinline block: ListResourcesRequest.Builder.() -> Unit): ListResourcesResponse = listResources(ListResourcesRequest.Builder().apply(block).build())

/**
 * Gets the tags for a project.
 */
public suspend inline fun CodeStarClient.listTagsForProject(crossinline block: ListTagsForProjectRequest.Builder.() -> Unit): ListTagsForProjectResponse = listTagsForProject(ListTagsForProjectRequest.Builder().apply(block).build())

/**
 * Lists all team members associated with a project.
 */
public suspend inline fun CodeStarClient.listTeamMembers(crossinline block: ListTeamMembersRequest.Builder.() -> Unit): ListTeamMembersResponse = listTeamMembers(ListTeamMembersRequest.Builder().apply(block).build())

/**
 * Lists all the user profiles configured for your AWS account in AWS CodeStar.
 */
public suspend inline fun CodeStarClient.listUserProfiles(crossinline block: ListUserProfilesRequest.Builder.() -> Unit): ListUserProfilesResponse = listUserProfiles(ListUserProfilesRequest.Builder().apply(block).build())

/**
 * Adds tags to a project.
 */
public suspend inline fun CodeStarClient.tagProject(crossinline block: TagProjectRequest.Builder.() -> Unit): TagProjectResponse = tagProject(TagProjectRequest.Builder().apply(block).build())

/**
 * Removes tags from a project.
 */
public suspend inline fun CodeStarClient.untagProject(crossinline block: UntagProjectRequest.Builder.() -> Unit): UntagProjectResponse = untagProject(UntagProjectRequest.Builder().apply(block).build())

/**
 * Updates a project in AWS CodeStar.
 */
public suspend inline fun CodeStarClient.updateProject(crossinline block: UpdateProjectRequest.Builder.() -> Unit): UpdateProjectResponse = updateProject(UpdateProjectRequest.Builder().apply(block).build())

/**
 * Updates a team member's attributes in an AWS CodeStar project. For example, you can change a team member's role in the project, or change whether they have remote access to project resources.
 */
public suspend inline fun CodeStarClient.updateTeamMember(crossinline block: UpdateTeamMemberRequest.Builder.() -> Unit): UpdateTeamMemberResponse = updateTeamMember(UpdateTeamMemberRequest.Builder().apply(block).build())

/**
 * Updates a user's profile in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.
 */
public suspend inline fun CodeStarClient.updateUserProfile(crossinline block: UpdateUserProfileRequest.Builder.() -> Unit): UpdateUserProfileResponse = updateUserProfile(UpdateUserProfileRequest.Builder().apply(block).build())
