// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar.serde

import aws.sdk.kotlin.services.codestar.model.CodeStarException
import aws.sdk.kotlin.services.codestar.model.UpdateTeamMemberResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateTeamMemberOperationDeserializer: HttpDeserialize<UpdateTeamMemberResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateTeamMemberResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateTeamMemberError(context, call)
        }
        val builder = UpdateTeamMemberResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateTeamMemberOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateTeamMemberError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeStarException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidServiceRoleException" -> InvalidServiceRoleExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ProjectConfigurationException" -> ProjectConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "ProjectNotFoundException" -> ProjectNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TeamMemberNotFoundException" -> TeamMemberNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeStarException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateTeamMemberOperationBody(builder: UpdateTeamMemberResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROJECTROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectRole"))
    val REMOTEACCESSALLOWED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("remoteAccessAllowed"))
    val USERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("userArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROJECTROLE_DESCRIPTOR)
        field(REMOTEACCESSALLOWED_DESCRIPTOR)
        field(USERARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROJECTROLE_DESCRIPTOR.index -> builder.projectRole = deserializeString()
                REMOTEACCESSALLOWED_DESCRIPTOR.index -> builder.remoteAccessAllowed = deserializeBoolean()
                USERARN_DESCRIPTOR.index -> builder.userArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
