// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar.model



/**
 * Information about a team member in a project.
 */
public class TeamMember private constructor(builder: Builder) {
    /**
     * The role assigned to the user in the project. Project roles have different levels of access. For more information, see [Working with Teams](http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html) in the *AWS CodeStar User Guide*.
     */
    public val projectRole: kotlin.String = requireNotNull(builder.projectRole) { "A non-null value must be provided for projectRole" }
    /**
     * Whether the user is allowed to remotely access project resources using an SSH public/private key pair.
     */
    public val remoteAccessAllowed: kotlin.Boolean? = builder.remoteAccessAllowed
    /**
     * The Amazon Resource Name (ARN) of the user in IAM.
     */
    public val userArn: kotlin.String = requireNotNull(builder.userArn) { "A non-null value must be provided for userArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codestar.model.TeamMember = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TeamMember(")
        append("projectRole=$projectRole,")
        append("remoteAccessAllowed=$remoteAccessAllowed,")
        append("userArn=$userArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = projectRole.hashCode()
        result = 31 * result + (remoteAccessAllowed?.hashCode() ?: 0)
        result = 31 * result + (userArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TeamMember

        if (projectRole != other.projectRole) return false
        if (remoteAccessAllowed != other.remoteAccessAllowed) return false
        if (userArn != other.userArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codestar.model.TeamMember = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The role assigned to the user in the project. Project roles have different levels of access. For more information, see [Working with Teams](http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html) in the *AWS CodeStar User Guide*.
         */
        public var projectRole: kotlin.String? = null
        /**
         * Whether the user is allowed to remotely access project resources using an SSH public/private key pair.
         */
        public var remoteAccessAllowed: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the user in IAM.
         */
        public var userArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codestar.model.TeamMember) : this() {
            this.projectRole = x.projectRole
            this.remoteAccessAllowed = x.remoteAccessAllowed
            this.userArn = x.userArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codestar.model.TeamMember = TeamMember(this)

        internal fun correctErrors(): Builder {
            if (projectRole == null) projectRole = ""
            if (userArn == null) userArn = ""
            return this
        }
    }
}
