// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.codestar.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.codestar.endpoints.EndpointProvider
import aws.sdk.kotlin.services.codestar.model.*
import aws.sdk.kotlin.services.codestar.model.AssociateTeamMemberRequest
import aws.sdk.kotlin.services.codestar.model.AssociateTeamMemberResponse
import aws.sdk.kotlin.services.codestar.model.CreateProjectRequest
import aws.sdk.kotlin.services.codestar.model.CreateProjectResponse
import aws.sdk.kotlin.services.codestar.model.CreateUserProfileRequest
import aws.sdk.kotlin.services.codestar.model.CreateUserProfileResponse
import aws.sdk.kotlin.services.codestar.model.DeleteProjectRequest
import aws.sdk.kotlin.services.codestar.model.DeleteProjectResponse
import aws.sdk.kotlin.services.codestar.model.DeleteUserProfileRequest
import aws.sdk.kotlin.services.codestar.model.DeleteUserProfileResponse
import aws.sdk.kotlin.services.codestar.model.DescribeProjectRequest
import aws.sdk.kotlin.services.codestar.model.DescribeProjectResponse
import aws.sdk.kotlin.services.codestar.model.DescribeUserProfileRequest
import aws.sdk.kotlin.services.codestar.model.DescribeUserProfileResponse
import aws.sdk.kotlin.services.codestar.model.DisassociateTeamMemberRequest
import aws.sdk.kotlin.services.codestar.model.DisassociateTeamMemberResponse
import aws.sdk.kotlin.services.codestar.model.ListProjectsRequest
import aws.sdk.kotlin.services.codestar.model.ListProjectsResponse
import aws.sdk.kotlin.services.codestar.model.ListResourcesRequest
import aws.sdk.kotlin.services.codestar.model.ListResourcesResponse
import aws.sdk.kotlin.services.codestar.model.ListTagsForProjectRequest
import aws.sdk.kotlin.services.codestar.model.ListTagsForProjectResponse
import aws.sdk.kotlin.services.codestar.model.ListTeamMembersRequest
import aws.sdk.kotlin.services.codestar.model.ListTeamMembersResponse
import aws.sdk.kotlin.services.codestar.model.ListUserProfilesRequest
import aws.sdk.kotlin.services.codestar.model.ListUserProfilesResponse
import aws.sdk.kotlin.services.codestar.model.TagProjectRequest
import aws.sdk.kotlin.services.codestar.model.TagProjectResponse
import aws.sdk.kotlin.services.codestar.model.UntagProjectRequest
import aws.sdk.kotlin.services.codestar.model.UntagProjectResponse
import aws.sdk.kotlin.services.codestar.model.UpdateProjectRequest
import aws.sdk.kotlin.services.codestar.model.UpdateProjectResponse
import aws.sdk.kotlin.services.codestar.model.UpdateTeamMemberRequest
import aws.sdk.kotlin.services.codestar.model.UpdateTeamMemberResponse
import aws.sdk.kotlin.services.codestar.model.UpdateUserProfileRequest
import aws.sdk.kotlin.services.codestar.model.UpdateUserProfileResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * # AWS CodeStar
 * This is the API reference for AWS CodeStar. This reference provides descriptions of the operations and data types for the AWS CodeStar API along with usage examples.
 *
 * You can use the AWS CodeStar API to work with:
 *
 * Projects and their resources, by calling the following:
 * + `DeleteProject`, which deletes a project.
 * + `DescribeProject`, which lists the attributes of a project.
 * + `ListProjects`, which lists all projects associated with your AWS account.
 * + `ListResources`, which lists the resources associated with a project.
 * + `ListTagsForProject`, which lists the tags associated with a project.
 * + `TagProject`, which adds tags to a project.
 * + `UntagProject`, which removes tags from a project.
 * + `UpdateProject`, which updates the attributes of a project.
 *
 * Teams and team members, by calling the following:
 * + `AssociateTeamMember`, which adds an IAM user to the team for a project.
 * + `DisassociateTeamMember`, which removes an IAM user from the team for a project.
 * + `ListTeamMembers`, which lists all the IAM users in the team for a project, including their roles and attributes.
 * + `UpdateTeamMember`, which updates a team member's attributes in a project.
 *
 * Users, by calling the following:
 * + `CreateUserProfile`, which creates a user profile that contains data associated with the user across all projects.
 * + `DeleteUserProfile`, which deletes all user profile information across all projects.
 * + `DescribeUserProfile`, which describes the profile of a user.
 * + `ListUserProfiles`, which lists all user profiles.
 * + `UpdateUserProfile`, which updates the profile for a user.
 */
public interface CodeStarClient : SdkClient {

    override val serviceName: String
        get() = "CodeStar"
    /**
     * CodeStarClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): CodeStarClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCodeStarClient(config)
        }

        public operator fun invoke(config: Config): CodeStarClient = DefaultCodeStarClient(config)

        /**
         * Construct a [CodeStarClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CodeStarClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultCodeStarClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "CodeStar")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds an IAM user to the team for an AWS CodeStar project.
     */
    public suspend fun associateTeamMember(input: AssociateTeamMemberRequest): AssociateTeamMemberResponse

    /**
     * Creates a project, including project resources. This action creates a project based on a submitted project request. A set of source code files and a toolchain template file can be included with the project request. If these are not provided, an empty project is created.
     */
    public suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Creates a profile for a user that includes user preferences, such as the display name and email address assocciated with the user, in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.
     */
    public suspend fun createUserProfile(input: CreateUserProfileRequest): CreateUserProfileResponse

    /**
     * Deletes a project, including project resources. Does not delete users associated with the project, but does delete the IAM roles that allowed access to the project.
     */
    public suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Deletes a user profile in AWS CodeStar, including all personal preference data associated with that profile, such as display name and email address. It does not delete the history of that user, for example the history of commits made by that user.
     */
    public suspend fun deleteUserProfile(input: DeleteUserProfileRequest): DeleteUserProfileResponse

    /**
     * Describes a project and its resources.
     */
    public suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Describes a user in AWS CodeStar and the user attributes across all projects.
     */
    public suspend fun describeUserProfile(input: DescribeUserProfileRequest): DescribeUserProfileResponse

    /**
     * Removes a user from a project. Removing a user from a project also removes the IAM policies from that user that allowed access to the project and its resources. Disassociating a team member does not remove that user's profile from AWS CodeStar. It does not remove the user from IAM.
     */
    public suspend fun disassociateTeamMember(input: DisassociateTeamMemberRequest): DisassociateTeamMemberResponse

    /**
     * Lists all projects in AWS CodeStar associated with your AWS account.
     */
    public suspend fun listProjects(input: ListProjectsRequest = ListProjectsRequest {}): ListProjectsResponse

    /**
     * Lists resources associated with a project in AWS CodeStar.
     */
    public suspend fun listResources(input: ListResourcesRequest): ListResourcesResponse

    /**
     * Gets the tags for a project.
     */
    public suspend fun listTagsForProject(input: ListTagsForProjectRequest): ListTagsForProjectResponse

    /**
     * Lists all team members associated with a project.
     */
    public suspend fun listTeamMembers(input: ListTeamMembersRequest): ListTeamMembersResponse

    /**
     * Lists all the user profiles configured for your AWS account in AWS CodeStar.
     */
    public suspend fun listUserProfiles(input: ListUserProfilesRequest = ListUserProfilesRequest {}): ListUserProfilesResponse

    /**
     * Adds tags to a project.
     */
    public suspend fun tagProject(input: TagProjectRequest): TagProjectResponse

    /**
     * Removes tags from a project.
     */
    public suspend fun untagProject(input: UntagProjectRequest): UntagProjectResponse

    /**
     * Updates a project in AWS CodeStar.
     */
    public suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse

    /**
     * Updates a team member's attributes in an AWS CodeStar project. For example, you can change a team member's role in the project, or change whether they have remote access to project resources.
     */
    public suspend fun updateTeamMember(input: UpdateTeamMemberRequest): UpdateTeamMemberResponse

    /**
     * Updates a user's profile in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.
     */
    public suspend fun updateUserProfile(input: UpdateUserProfileRequest): UpdateUserProfileResponse
}

/**
 * Adds an IAM user to the team for an AWS CodeStar project.
 */
public suspend inline fun CodeStarClient.associateTeamMember(crossinline block: AssociateTeamMemberRequest.Builder.() -> Unit): AssociateTeamMemberResponse = associateTeamMember(AssociateTeamMemberRequest.Builder().apply(block).build())

/**
 * Creates a project, including project resources. This action creates a project based on a submitted project request. A set of source code files and a toolchain template file can be included with the project request. If these are not provided, an empty project is created.
 */
public suspend inline fun CodeStarClient.createProject(crossinline block: CreateProjectRequest.Builder.() -> Unit): CreateProjectResponse = createProject(CreateProjectRequest.Builder().apply(block).build())

/**
 * Creates a profile for a user that includes user preferences, such as the display name and email address assocciated with the user, in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.
 */
public suspend inline fun CodeStarClient.createUserProfile(crossinline block: CreateUserProfileRequest.Builder.() -> Unit): CreateUserProfileResponse = createUserProfile(CreateUserProfileRequest.Builder().apply(block).build())

/**
 * Deletes a project, including project resources. Does not delete users associated with the project, but does delete the IAM roles that allowed access to the project.
 */
public suspend inline fun CodeStarClient.deleteProject(crossinline block: DeleteProjectRequest.Builder.() -> Unit): DeleteProjectResponse = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

/**
 * Deletes a user profile in AWS CodeStar, including all personal preference data associated with that profile, such as display name and email address. It does not delete the history of that user, for example the history of commits made by that user.
 */
public suspend inline fun CodeStarClient.deleteUserProfile(crossinline block: DeleteUserProfileRequest.Builder.() -> Unit): DeleteUserProfileResponse = deleteUserProfile(DeleteUserProfileRequest.Builder().apply(block).build())

/**
 * Describes a project and its resources.
 */
public suspend inline fun CodeStarClient.describeProject(crossinline block: DescribeProjectRequest.Builder.() -> Unit): DescribeProjectResponse = describeProject(DescribeProjectRequest.Builder().apply(block).build())

/**
 * Describes a user in AWS CodeStar and the user attributes across all projects.
 */
public suspend inline fun CodeStarClient.describeUserProfile(crossinline block: DescribeUserProfileRequest.Builder.() -> Unit): DescribeUserProfileResponse = describeUserProfile(DescribeUserProfileRequest.Builder().apply(block).build())

/**
 * Removes a user from a project. Removing a user from a project also removes the IAM policies from that user that allowed access to the project and its resources. Disassociating a team member does not remove that user's profile from AWS CodeStar. It does not remove the user from IAM.
 */
public suspend inline fun CodeStarClient.disassociateTeamMember(crossinline block: DisassociateTeamMemberRequest.Builder.() -> Unit): DisassociateTeamMemberResponse = disassociateTeamMember(DisassociateTeamMemberRequest.Builder().apply(block).build())

/**
 * Lists all projects in AWS CodeStar associated with your AWS account.
 */
public suspend inline fun CodeStarClient.listProjects(crossinline block: ListProjectsRequest.Builder.() -> Unit): ListProjectsResponse = listProjects(ListProjectsRequest.Builder().apply(block).build())

/**
 * Lists resources associated with a project in AWS CodeStar.
 */
public suspend inline fun CodeStarClient.listResources(crossinline block: ListResourcesRequest.Builder.() -> Unit): ListResourcesResponse = listResources(ListResourcesRequest.Builder().apply(block).build())

/**
 * Gets the tags for a project.
 */
public suspend inline fun CodeStarClient.listTagsForProject(crossinline block: ListTagsForProjectRequest.Builder.() -> Unit): ListTagsForProjectResponse = listTagsForProject(ListTagsForProjectRequest.Builder().apply(block).build())

/**
 * Lists all team members associated with a project.
 */
public suspend inline fun CodeStarClient.listTeamMembers(crossinline block: ListTeamMembersRequest.Builder.() -> Unit): ListTeamMembersResponse = listTeamMembers(ListTeamMembersRequest.Builder().apply(block).build())

/**
 * Lists all the user profiles configured for your AWS account in AWS CodeStar.
 */
public suspend inline fun CodeStarClient.listUserProfiles(crossinline block: ListUserProfilesRequest.Builder.() -> Unit): ListUserProfilesResponse = listUserProfiles(ListUserProfilesRequest.Builder().apply(block).build())

/**
 * Adds tags to a project.
 */
public suspend inline fun CodeStarClient.tagProject(crossinline block: TagProjectRequest.Builder.() -> Unit): TagProjectResponse = tagProject(TagProjectRequest.Builder().apply(block).build())

/**
 * Removes tags from a project.
 */
public suspend inline fun CodeStarClient.untagProject(crossinline block: UntagProjectRequest.Builder.() -> Unit): UntagProjectResponse = untagProject(UntagProjectRequest.Builder().apply(block).build())

/**
 * Updates a project in AWS CodeStar.
 */
public suspend inline fun CodeStarClient.updateProject(crossinline block: UpdateProjectRequest.Builder.() -> Unit): UpdateProjectResponse = updateProject(UpdateProjectRequest.Builder().apply(block).build())

/**
 * Updates a team member's attributes in an AWS CodeStar project. For example, you can change a team member's role in the project, or change whether they have remote access to project resources.
 */
public suspend inline fun CodeStarClient.updateTeamMember(crossinline block: UpdateTeamMemberRequest.Builder.() -> Unit): UpdateTeamMemberResponse = updateTeamMember(UpdateTeamMemberRequest.Builder().apply(block).build())

/**
 * Updates a user's profile in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.
 */
public suspend inline fun CodeStarClient.updateUserProfile(crossinline block: UpdateUserProfileRequest.Builder.() -> Unit): UpdateUserProfileResponse = updateUserProfile(UpdateUserProfileRequest.Builder().apply(block).build())
