// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.serde

import aws.sdk.kotlin.services.codepipeline.model.CodePipelineException
import aws.sdk.kotlin.services.codepipeline.model.GetPipelineStateResponse
import aws.sdk.kotlin.services.codepipeline.model.StageState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetPipelineStateOperationDeserializer: HttpDeserializer.NonStreaming<GetPipelineStateResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetPipelineStateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPipelineStateError(context, call, payload)
        }
        val builder = GetPipelineStateResponse.Builder()

        if (payload != null) {
            deserializeGetPipelineStateOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetPipelineStateError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodePipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "PipelineNotFoundException" -> PipelineNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodePipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPipelineStateOperationBody(builder: GetPipelineStateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("created"))
    val PIPELINENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("pipelineName"))
    val PIPELINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("pipelineVersion"))
    val STAGESTATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("stageStates"))
    val UPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updated"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATED_DESCRIPTOR)
        field(PIPELINENAME_DESCRIPTOR)
        field(PIPELINEVERSION_DESCRIPTOR)
        field(STAGESTATES_DESCRIPTOR)
        field(UPDATED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATED_DESCRIPTOR.index -> builder.created = deserializeString().let { Instant.fromEpochSeconds(it) }
                PIPELINENAME_DESCRIPTOR.index -> builder.pipelineName = deserializeString()
                PIPELINEVERSION_DESCRIPTOR.index -> builder.pipelineVersion = deserializeInt()
                STAGESTATES_DESCRIPTOR.index -> builder.stageStates =
                    deserializer.deserializeList(STAGESTATES_DESCRIPTOR) {
                        val col0 = mutableListOf<StageState>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeStageStateDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UPDATED_DESCRIPTOR.index -> builder.updated = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
