// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input of a `StartPipelineExecution` action.
 */
public class StartPipelineExecutionRequest private constructor(builder: Builder) {
    /**
     * The system-generated unique ID used to identify a unique execution request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of the pipeline to start.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list that allows you to specify, or override, the source revision for a pipeline execution that's being started. A source revision is the version with all the changes to your application code, or source artifact, for the pipeline execution.
     */
    public val sourceRevisions: List<SourceRevisionOverride>? = builder.sourceRevisions
    /**
     * A list that overrides pipeline variables for a pipeline execution that's being started. Variable names must match `[A-Za-z0-9@\-_]+`, and the values can be anything except an empty string.
     */
    public val variables: List<PipelineVariable>? = builder.variables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.StartPipelineExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartPipelineExecutionRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("name=$name,")
        append("sourceRevisions=$sourceRevisions,")
        append("variables=$variables")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sourceRevisions?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartPipelineExecutionRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (name != other.name) return false
        if (sourceRevisions != other.sourceRevisions) return false
        if (variables != other.variables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.StartPipelineExecutionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The system-generated unique ID used to identify a unique execution request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The name of the pipeline to start.
         */
        public var name: kotlin.String? = null
        /**
         * A list that allows you to specify, or override, the source revision for a pipeline execution that's being started. A source revision is the version with all the changes to your application code, or source artifact, for the pipeline execution.
         */
        public var sourceRevisions: List<SourceRevisionOverride>? = null
        /**
         * A list that overrides pipeline variables for a pipeline execution that's being started. Variable names must match `[A-Za-z0-9@\-_]+`, and the values can be anything except an empty string.
         */
        public var variables: List<PipelineVariable>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.StartPipelineExecutionRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.name = x.name
            this.sourceRevisions = x.sourceRevisions
            this.variables = x.variables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.StartPipelineExecutionRequest = StartPipelineExecutionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
