// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents information about the specified trigger configuration, such as the filter criteria and the source stage for the action that contains the trigger.
 *
 * This is only supported for the `CodeStarSourceConnection` action type.
 *
 * When a trigger configuration is specified, default change detection for repository and branch commits is disabled.
 */
public class PipelineTriggerDeclaration private constructor(builder: Builder) {
    /**
     * Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
     */
    public val gitConfiguration: aws.sdk.kotlin.services.codepipeline.model.GitConfiguration? = builder.gitConfiguration
    /**
     * The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration.
     */
    public val providerType: aws.sdk.kotlin.services.codepipeline.model.PipelineTriggerProviderType = requireNotNull(builder.providerType) { "A non-null value must be provided for providerType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.PipelineTriggerDeclaration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PipelineTriggerDeclaration(")
        append("gitConfiguration=$gitConfiguration,")
        append("providerType=$providerType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gitConfiguration?.hashCode() ?: 0
        result = 31 * result + (providerType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PipelineTriggerDeclaration

        if (gitConfiguration != other.gitConfiguration) return false
        if (providerType != other.providerType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.PipelineTriggerDeclaration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
         */
        public var gitConfiguration: aws.sdk.kotlin.services.codepipeline.model.GitConfiguration? = null
        /**
         * The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration.
         */
        public var providerType: aws.sdk.kotlin.services.codepipeline.model.PipelineTriggerProviderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.PipelineTriggerDeclaration) : this() {
            this.gitConfiguration = x.gitConfiguration
            this.providerType = x.providerType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.PipelineTriggerDeclaration = PipelineTriggerDeclaration(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.GitConfiguration] inside the given [block]
         */
        public fun gitConfiguration(block: aws.sdk.kotlin.services.codepipeline.model.GitConfiguration.Builder.() -> kotlin.Unit) {
            this.gitConfiguration = aws.sdk.kotlin.services.codepipeline.model.GitConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (providerType == null) providerType = PipelineTriggerProviderType.SdkUnknown("no value provided")
            return this
        }
    }
}
