// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a pipeline.
 */
public class PipelineMetadata private constructor(builder: Builder) {
    /**
     * The date and time the pipeline was created, in timestamp format.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The Amazon Resource Name (ARN) of the pipeline.
     */
    public val pipelineArn: kotlin.String? = builder.pipelineArn
    /**
     * The date and time that polling for source changes (periodic checks) was stopped for the pipeline, in timestamp format. You can migrate (update) a polling pipeline to use event-based change detection. For example, for a pipeline with a CodeCommit source, we recommend you migrate (update) your pipeline to use CloudWatch Events. To learn more, see [Migrate polling pipelines to use event-based change detection](https://docs.aws.amazon.com/codepipeline/latest/userguide/update-change-detection.html) in the CodePipeline User Guide.
     */
    public val pollingDisabledAt: aws.smithy.kotlin.runtime.time.Instant? = builder.pollingDisabledAt
    /**
     * The date and time the pipeline was last updated, in timestamp format.
     */
    public val updated: aws.smithy.kotlin.runtime.time.Instant? = builder.updated

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.PipelineMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PipelineMetadata(")
        append("created=$created,")
        append("pipelineArn=$pipelineArn,")
        append("pollingDisabledAt=$pollingDisabledAt,")
        append("updated=$updated")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = created?.hashCode() ?: 0
        result = 31 * result + (pipelineArn?.hashCode() ?: 0)
        result = 31 * result + (pollingDisabledAt?.hashCode() ?: 0)
        result = 31 * result + (updated?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PipelineMetadata

        if (created != other.created) return false
        if (pipelineArn != other.pipelineArn) return false
        if (pollingDisabledAt != other.pollingDisabledAt) return false
        if (updated != other.updated) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.PipelineMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time the pipeline was created, in timestamp format.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the pipeline.
         */
        public var pipelineArn: kotlin.String? = null
        /**
         * The date and time that polling for source changes (periodic checks) was stopped for the pipeline, in timestamp format. You can migrate (update) a polling pipeline to use event-based change detection. For example, for a pipeline with a CodeCommit source, we recommend you migrate (update) your pipeline to use CloudWatch Events. To learn more, see [Migrate polling pipelines to use event-based change detection](https://docs.aws.amazon.com/codepipeline/latest/userguide/update-change-detection.html) in the CodePipeline User Guide.
         */
        public var pollingDisabledAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time the pipeline was last updated, in timestamp format.
         */
        public var updated: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.PipelineMetadata) : this() {
            this.created = x.created
            this.pipelineArn = x.pipelineArn
            this.pollingDisabledAt = x.pollingDisabledAt
            this.updated = x.updated
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.PipelineMetadata = PipelineMetadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
