// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents information about a job.
 */
public class Job private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account to use when performing the job.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * Other data about a job.
     */
    public val data: aws.sdk.kotlin.services.codepipeline.model.JobData? = builder.data
    /**
     * The unique system-generated ID of the job.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A system-generated random number that CodePipeline uses to ensure that the job is being worked on by only one job worker. Use this number in an AcknowledgeJob request.
     */
    public val nonce: kotlin.String? = builder.nonce

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.Job = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Job(")
        append("accountId=$accountId,")
        append("data=$data,")
        append("id=$id,")
        append("nonce=$nonce")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (data?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (nonce?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Job

        if (accountId != other.accountId) return false
        if (data != other.data) return false
        if (id != other.id) return false
        if (nonce != other.nonce) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.Job = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account to use when performing the job.
         */
        public var accountId: kotlin.String? = null
        /**
         * Other data about a job.
         */
        public var data: aws.sdk.kotlin.services.codepipeline.model.JobData? = null
        /**
         * The unique system-generated ID of the job.
         */
        public var id: kotlin.String? = null
        /**
         * A system-generated random number that CodePipeline uses to ensure that the job is being worked on by only one job worker. Use this number in an AcknowledgeJob request.
         */
        public var nonce: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.Job) : this() {
            this.accountId = x.accountId
            this.data = x.data
            this.id = x.id
            this.nonce = x.nonce
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.Job = Job(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.JobData] inside the given [block]
         */
        public fun data(block: aws.sdk.kotlin.services.codepipeline.model.JobData.Builder.() -> kotlin.Unit) {
            this.data = aws.sdk.kotlin.services.codepipeline.model.JobData.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
