// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents information about the key used to encrypt data in the artifact store, such as an Amazon Web Services Key Management Service (Key Management Service) key.
 */
public class EncryptionKey private constructor(builder: Builder) {
    /**
     * The ID used to identify the key. For an Amazon Web Services KMS key, you can use the key ID, the key ARN, or the alias ARN.
     *
     * Aliases are recognized only in the account that created the KMS key. For cross-account actions, you can only use the key ID or key ARN to identify the key. Cross-account actions involve using the role from the other account (AccountB), so specifying the key ID will use the key from the other account (AccountB).
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The type of encryption key, such as an Amazon Web Services KMS key. When creating or updating a pipeline, the value must be set to 'KMS'.
     */
    public val type: aws.sdk.kotlin.services.codepipeline.model.EncryptionKeyType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.EncryptionKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionKey(")
        append("id=$id,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id.hashCode()
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionKey

        if (id != other.id) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.EncryptionKey = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID used to identify the key. For an Amazon Web Services KMS key, you can use the key ID, the key ARN, or the alias ARN.
         *
         * Aliases are recognized only in the account that created the KMS key. For cross-account actions, you can only use the key ID or key ARN to identify the key. Cross-account actions involve using the role from the other account (AccountB), so specifying the key ID will use the key from the other account (AccountB).
         */
        public var id: kotlin.String? = null
        /**
         * The type of encryption key, such as an Amazon Web Services KMS key. When creating or updating a pipeline, the value must be set to 'KMS'.
         */
        public var type: aws.sdk.kotlin.services.codepipeline.model.EncryptionKeyType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.EncryptionKey) : this() {
            this.id = x.id
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.EncryptionKey = EncryptionKey(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (type == null) type = EncryptionKeyType.SdkUnknown("no value provided")
            return this
        }
    }
}
