// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the category, owner, provider, and version of the action type.
 */
public class ActionTypeIdentifier private constructor(builder: Builder) {
    /**
     * Defines what kind of action can be taken in the stage, one of the following:
     * + `Source`
     * + `Build`
     * + `Test`
     * + `Deploy`
     * + `Approval`
     * + `Invoke`
     */
    public val category: aws.sdk.kotlin.services.codepipeline.model.ActionCategory = requireNotNull(builder.category) { "A non-null value must be provided for category" }
    /**
     * The creator of the action type being called: `AWS` or `ThirdParty`.
     */
    public val owner: kotlin.String = requireNotNull(builder.owner) { "A non-null value must be provided for owner" }
    /**
     * The provider of the action type being called. The provider name is supplied when the action type is created.
     */
    public val provider: kotlin.String = requireNotNull(builder.provider) { "A non-null value must be provided for provider" }
    /**
     * A string that describes the action type version.
     */
    public val version: kotlin.String = requireNotNull(builder.version) { "A non-null value must be provided for version" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ActionTypeIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionTypeIdentifier(")
        append("category=$category,")
        append("owner=$owner,")
        append("provider=$provider,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = category.hashCode()
        result = 31 * result + (owner.hashCode())
        result = 31 * result + (provider.hashCode())
        result = 31 * result + (version.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionTypeIdentifier

        if (category != other.category) return false
        if (owner != other.owner) return false
        if (provider != other.provider) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ActionTypeIdentifier = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines what kind of action can be taken in the stage, one of the following:
         * + `Source`
         * + `Build`
         * + `Test`
         * + `Deploy`
         * + `Approval`
         * + `Invoke`
         */
        public var category: aws.sdk.kotlin.services.codepipeline.model.ActionCategory? = null
        /**
         * The creator of the action type being called: `AWS` or `ThirdParty`.
         */
        public var owner: kotlin.String? = null
        /**
         * The provider of the action type being called. The provider name is supplied when the action type is created.
         */
        public var provider: kotlin.String? = null
        /**
         * A string that describes the action type version.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ActionTypeIdentifier) : this() {
            this.category = x.category
            this.owner = x.owner
            this.provider = x.provider
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ActionTypeIdentifier = ActionTypeIdentifier(this)

        internal fun correctErrors(): Builder {
            if (category == null) category = ActionCategory.SdkUnknown("no value provided")
            if (owner == null) owner = ""
            if (provider == null) provider = ""
            if (version == null) version = ""
            return this
        }
    }
}
