// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The action engine, or executor, for an action type created for a provider, where the action is to be used by customers of the provider. The action engine is associated with the model used to create and update the action, such as the Lambda integration model.
 */
public class ActionTypeExecutor private constructor(builder: Builder) {
    /**
     * The action configuration properties for the action type. These properties are specified in the action definition when the action type is created.
     */
    public val configuration: aws.sdk.kotlin.services.codepipeline.model.ExecutorConfiguration? = builder.configuration
    /**
     * The timeout in seconds for the job. An action execution can have multiple jobs. This is the timeout for a single job, not the entire action execution.
     */
    public val jobTimeout: kotlin.Int? = builder.jobTimeout
    /**
     * The policy statement that specifies the permissions in the CodePipeline customer account that are needed to successfully run an action.
     *
     * To grant permission to another account, specify the account ID as the Principal, a domain-style identifier defined by the service, for example `codepipeline.amazonaws.com`.
     *
     * The size of the passed JSON policy document cannot exceed 2048 characters.
     */
    public val policyStatementsTemplate: kotlin.String? = builder.policyStatementsTemplate
    /**
     * The integration model used to create and update the action type, `Lambda` or `JobWorker`.
     */
    public val type: aws.sdk.kotlin.services.codepipeline.model.ExecutorType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ActionTypeExecutor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionTypeExecutor(")
        append("configuration=$configuration,")
        append("jobTimeout=$jobTimeout,")
        append("policyStatementsTemplate=$policyStatementsTemplate,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (jobTimeout ?: 0)
        result = 31 * result + (policyStatementsTemplate?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionTypeExecutor

        if (configuration != other.configuration) return false
        if (jobTimeout != other.jobTimeout) return false
        if (policyStatementsTemplate != other.policyStatementsTemplate) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ActionTypeExecutor = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action configuration properties for the action type. These properties are specified in the action definition when the action type is created.
         */
        public var configuration: aws.sdk.kotlin.services.codepipeline.model.ExecutorConfiguration? = null
        /**
         * The timeout in seconds for the job. An action execution can have multiple jobs. This is the timeout for a single job, not the entire action execution.
         */
        public var jobTimeout: kotlin.Int? = null
        /**
         * The policy statement that specifies the permissions in the CodePipeline customer account that are needed to successfully run an action.
         *
         * To grant permission to another account, specify the account ID as the Principal, a domain-style identifier defined by the service, for example `codepipeline.amazonaws.com`.
         *
         * The size of the passed JSON policy document cannot exceed 2048 characters.
         */
        public var policyStatementsTemplate: kotlin.String? = null
        /**
         * The integration model used to create and update the action type, `Lambda` or `JobWorker`.
         */
        public var type: aws.sdk.kotlin.services.codepipeline.model.ExecutorType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ActionTypeExecutor) : this() {
            this.configuration = x.configuration
            this.jobTimeout = x.jobTimeout
            this.policyStatementsTemplate = x.policyStatementsTemplate
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ActionTypeExecutor = ActionTypeExecutor(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ExecutorConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.codepipeline.model.ExecutorConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.codepipeline.model.ExecutorConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (type == null) type = ExecutorType.SdkUnknown("no value provided")
            return this
        }
    }
}
