// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Output details listed for an action execution, such as the action execution result.
 */
public class ActionExecutionOutput private constructor(builder: Builder) {
    /**
     * Execution result information listed in the output details for an action execution.
     */
    public val executionResult: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionResult? = builder.executionResult
    /**
     * Details of output artifacts of the action that correspond to the action execution.
     */
    public val outputArtifacts: List<ArtifactDetail>? = builder.outputArtifacts
    /**
     * The outputVariables field shows the key-value pairs that were output as part of that execution.
     */
    public val outputVariables: Map<String, String>? = builder.outputVariables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ActionExecutionOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionExecutionOutput(")
        append("executionResult=$executionResult,")
        append("outputArtifacts=$outputArtifacts,")
        append("outputVariables=$outputVariables")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionResult?.hashCode() ?: 0
        result = 31 * result + (outputArtifacts?.hashCode() ?: 0)
        result = 31 * result + (outputVariables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionExecutionOutput

        if (executionResult != other.executionResult) return false
        if (outputArtifacts != other.outputArtifacts) return false
        if (outputVariables != other.outputVariables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ActionExecutionOutput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Execution result information listed in the output details for an action execution.
         */
        public var executionResult: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionResult? = null
        /**
         * Details of output artifacts of the action that correspond to the action execution.
         */
        public var outputArtifacts: List<ArtifactDetail>? = null
        /**
         * The outputVariables field shows the key-value pairs that were output as part of that execution.
         */
        public var outputVariables: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionOutput) : this() {
            this.executionResult = x.executionResult
            this.outputArtifacts = x.outputArtifacts
            this.outputVariables = x.outputVariables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ActionExecutionOutput = ActionExecutionOutput(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionExecutionResult] inside the given [block]
         */
        public fun executionResult(block: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionResult.Builder.() -> kotlin.Unit) {
            this.executionResult = aws.sdk.kotlin.services.codepipeline.model.ActionExecutionResult.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
