// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.serde

import aws.sdk.kotlin.services.codepipeline.model.CodePipelineException
import aws.sdk.kotlin.services.codepipeline.model.EnableStageTransitionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class EnableStageTransitionOperationDeserializer: HttpDeserializer.NonStreaming<EnableStageTransitionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): EnableStageTransitionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwEnableStageTransitionError(context, call, payload)
        }
        val builder = EnableStageTransitionResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwEnableStageTransitionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodePipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "PipelineNotFoundException" -> PipelineNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "StageNotFoundException" -> StageNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodePipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
