// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.paginators

import aws.sdk.kotlin.services.codepipeline.CodePipelineClient
import aws.sdk.kotlin.services.codepipeline.model.ActionExecutionDetail
import aws.sdk.kotlin.services.codepipeline.model.ActionType
import aws.sdk.kotlin.services.codepipeline.model.ListActionExecutionsRequest
import aws.sdk.kotlin.services.codepipeline.model.ListActionExecutionsResponse
import aws.sdk.kotlin.services.codepipeline.model.ListActionTypesRequest
import aws.sdk.kotlin.services.codepipeline.model.ListActionTypesResponse
import aws.sdk.kotlin.services.codepipeline.model.ListPipelineExecutionsRequest
import aws.sdk.kotlin.services.codepipeline.model.ListPipelineExecutionsResponse
import aws.sdk.kotlin.services.codepipeline.model.ListPipelinesRequest
import aws.sdk.kotlin.services.codepipeline.model.ListPipelinesResponse
import aws.sdk.kotlin.services.codepipeline.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.codepipeline.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.codepipeline.model.ListWebhookItem
import aws.sdk.kotlin.services.codepipeline.model.ListWebhooksRequest
import aws.sdk.kotlin.services.codepipeline.model.ListWebhooksResponse
import aws.sdk.kotlin.services.codepipeline.model.PipelineExecutionSummary
import aws.sdk.kotlin.services.codepipeline.model.PipelineSummary
import aws.sdk.kotlin.services.codepipeline.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListActionExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListActionExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListActionExecutionsResponse]
 */
public fun CodePipelineClient.listActionExecutionsPaginated(initialRequest: ListActionExecutionsRequest): Flow<ListActionExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listActionExecutionsPaginated.listActionExecutions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListActionExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListActionExecutionsResponse]
 */
public fun CodePipelineClient.listActionExecutionsPaginated(block: ListActionExecutionsRequest.Builder.() -> Unit): Flow<ListActionExecutionsResponse> =
    listActionExecutionsPaginated(ListActionExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listActionExecutionsPaginated]
 * to access the nested member [ActionExecutionDetail]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ActionExecutionDetail]
 */
@JvmName("listActionExecutionsResponseActionExecutionDetail")
public fun Flow<ListActionExecutionsResponse>.actionExecutionDetails(): Flow<ActionExecutionDetail> =
    transform() { response ->
        response.actionExecutionDetails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListActionTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListActionTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListActionTypesResponse]
 */
public fun CodePipelineClient.listActionTypesPaginated(initialRequest: ListActionTypesRequest = ListActionTypesRequest { }): Flow<ListActionTypesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listActionTypesPaginated.listActionTypes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListActionTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListActionTypesResponse]
 */
public fun CodePipelineClient.listActionTypesPaginated(block: ListActionTypesRequest.Builder.() -> Unit): Flow<ListActionTypesResponse> =
    listActionTypesPaginated(ListActionTypesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listActionTypesPaginated]
 * to access the nested member [ActionType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ActionType]
 */
@JvmName("listActionTypesResponseActionType")
public fun Flow<ListActionTypesResponse>.actionTypes(): Flow<ActionType> =
    transform() { response ->
        response.actionTypes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPipelineExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPipelineExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPipelineExecutionsResponse]
 */
public fun CodePipelineClient.listPipelineExecutionsPaginated(initialRequest: ListPipelineExecutionsRequest): Flow<ListPipelineExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPipelineExecutionsPaginated.listPipelineExecutions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPipelineExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPipelineExecutionsResponse]
 */
public fun CodePipelineClient.listPipelineExecutionsPaginated(block: ListPipelineExecutionsRequest.Builder.() -> Unit): Flow<ListPipelineExecutionsResponse> =
    listPipelineExecutionsPaginated(ListPipelineExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPipelineExecutionsPaginated]
 * to access the nested member [PipelineExecutionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PipelineExecutionSummary]
 */
@JvmName("listPipelineExecutionsResponsePipelineExecutionSummary")
public fun Flow<ListPipelineExecutionsResponse>.pipelineExecutionSummaries(): Flow<PipelineExecutionSummary> =
    transform() { response ->
        response.pipelineExecutionSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPipelinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPipelinesResponse]
 */
public fun CodePipelineClient.listPipelinesPaginated(initialRequest: ListPipelinesRequest = ListPipelinesRequest { }): Flow<ListPipelinesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPipelinesPaginated.listPipelines(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPipelinesResponse]
 */
public fun CodePipelineClient.listPipelinesPaginated(block: ListPipelinesRequest.Builder.() -> Unit): Flow<ListPipelinesResponse> =
    listPipelinesPaginated(ListPipelinesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPipelinesPaginated]
 * to access the nested member [PipelineSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PipelineSummary]
 */
@JvmName("listPipelinesResponsePipelineSummary")
public fun Flow<ListPipelinesResponse>.pipelines(): Flow<PipelineSummary> =
    transform() { response ->
        response.pipelines?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun CodePipelineClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun CodePipelineClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
public fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWebhooksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWebhooksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWebhooksResponse]
 */
public fun CodePipelineClient.listWebhooksPaginated(initialRequest: ListWebhooksRequest = ListWebhooksRequest { }): Flow<ListWebhooksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWebhooksPaginated.listWebhooks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWebhooksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWebhooksResponse]
 */
public fun CodePipelineClient.listWebhooksPaginated(block: ListWebhooksRequest.Builder.() -> Unit): Flow<ListWebhooksResponse> =
    listWebhooksPaginated(ListWebhooksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWebhooksPaginated]
 * to access the nested member [ListWebhookItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWebhookItem]
 */
@JvmName("listWebhooksResponseListWebhookItem")
public fun Flow<ListWebhooksResponse>.webhooks(): Flow<ListWebhookItem> =
    transform() { response ->
        response.webhooks?.forEach {
            emit(it)
        }
    }
