// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents information about the run of a stage.
 */
public class StageExecution private constructor(builder: Builder) {
    /**
     * The ID of the pipeline execution associated with the stage.
     */
    public val pipelineExecutionId: kotlin.String = requireNotNull(builder.pipelineExecutionId) { "A non-null value must be provided for pipelineExecutionId" }
    /**
     * The status of the stage, or for a completed stage, the last status of the stage.
     *
     * A status of cancelled means that the pipeline’s definition was updated before the stage execution could be completed.
     */
    public val status: aws.sdk.kotlin.services.codepipeline.model.StageExecutionStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The type of pipeline execution for the stage, such as a rollback pipeline execution.
     */
    public val type: aws.sdk.kotlin.services.codepipeline.model.ExecutionType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.StageExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StageExecution(")
        append("pipelineExecutionId=$pipelineExecutionId,")
        append("status=$status,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = pipelineExecutionId.hashCode()
        result = 31 * result + (status.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StageExecution

        if (pipelineExecutionId != other.pipelineExecutionId) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.StageExecution = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the pipeline execution associated with the stage.
         */
        public var pipelineExecutionId: kotlin.String? = null
        /**
         * The status of the stage, or for a completed stage, the last status of the stage.
         *
         * A status of cancelled means that the pipeline’s definition was updated before the stage execution could be completed.
         */
        public var status: aws.sdk.kotlin.services.codepipeline.model.StageExecutionStatus? = null
        /**
         * The type of pipeline execution for the stage, such as a rollback pipeline execution.
         */
        public var type: aws.sdk.kotlin.services.codepipeline.model.ExecutionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.StageExecution) : this() {
            this.pipelineExecutionId = x.pipelineExecutionId
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.StageExecution = StageExecution(this)

        internal fun correctErrors(): Builder {
            if (pipelineExecutionId == null) pipelineExecutionId = ""
            if (status == null) status = StageExecutionStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
