// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents information about a stage and its definition.
 */
public class StageDeclaration private constructor(builder: Builder) {
    /**
     * The actions included in a stage.
     */
    public val actions: List<ActionDeclaration> = requireNotNull(builder.actions) { "A non-null value must be provided for actions" }
    /**
     * Reserved for future use.
     */
    public val blockers: List<BlockerDeclaration>? = builder.blockers
    /**
     * The name of the stage.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The method to use when a stage has not completed successfully. For example, configuring this field for rollback will roll back a failed stage automatically to the last successful pipeline execution in the stage.
     */
    public val onFailure: aws.sdk.kotlin.services.codepipeline.model.FailureConditions? = builder.onFailure

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.StageDeclaration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StageDeclaration(")
        append("actions=$actions,")
        append("blockers=$blockers,")
        append("name=$name,")
        append("onFailure=$onFailure")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions.hashCode()
        result = 31 * result + (blockers?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (onFailure?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StageDeclaration

        if (actions != other.actions) return false
        if (blockers != other.blockers) return false
        if (name != other.name) return false
        if (onFailure != other.onFailure) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.StageDeclaration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The actions included in a stage.
         */
        public var actions: List<ActionDeclaration>? = null
        /**
         * Reserved for future use.
         */
        public var blockers: List<BlockerDeclaration>? = null
        /**
         * The name of the stage.
         */
        public var name: kotlin.String? = null
        /**
         * The method to use when a stage has not completed successfully. For example, configuring this field for rollback will roll back a failed stage automatically to the last successful pipeline execution in the stage.
         */
        public var onFailure: aws.sdk.kotlin.services.codepipeline.model.FailureConditions? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.StageDeclaration) : this() {
            this.actions = x.actions
            this.blockers = x.blockers
            this.name = x.name
            this.onFailure = x.onFailure
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.StageDeclaration = StageDeclaration(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.FailureConditions] inside the given [block]
         */
        public fun onFailure(block: aws.sdk.kotlin.services.codepipeline.model.FailureConditions.Builder.() -> kotlin.Unit) {
            this.onFailure = aws.sdk.kotlin.services.codepipeline.model.FailureConditions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (actions == null) actions = emptyList()
            if (name == null) name = ""
            return this
        }
    }
}
