// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents information about an execution of a pipeline.
 */
public class PipelineExecution private constructor(builder: Builder) {
    /**
     * A list of `ArtifactRevision` objects included in a pipeline execution.
     */
    public val artifactRevisions: List<ArtifactRevision>? = builder.artifactRevisions
    /**
     * The method that the pipeline will use to handle multiple executions. The default mode is SUPERSEDED.
     */
    public val executionMode: aws.sdk.kotlin.services.codepipeline.model.ExecutionMode? = builder.executionMode
    /**
     * The type of the pipeline execution.
     */
    public val executionType: aws.sdk.kotlin.services.codepipeline.model.ExecutionType? = builder.executionType
    /**
     * The ID of the pipeline execution.
     */
    public val pipelineExecutionId: kotlin.String? = builder.pipelineExecutionId
    /**
     * The name of the pipeline with the specified pipeline execution.
     */
    public val pipelineName: kotlin.String? = builder.pipelineName
    /**
     * The version number of the pipeline with the specified pipeline execution.
     */
    public val pipelineVersion: kotlin.Int? = builder.pipelineVersion
    /**
     * The metadata about the execution pertaining to stage rollback.
     */
    public val rollbackMetadata: aws.sdk.kotlin.services.codepipeline.model.PipelineRollbackMetadata? = builder.rollbackMetadata
    /**
     * The status of the pipeline execution.
     * + Cancelled: The pipeline’s definition was updated before the pipeline execution could be completed.
     * + InProgress: The pipeline execution is currently running.
     * + Stopped: The pipeline execution was manually stopped. For more information, see [Stopped Executions](https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
     * + Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see [Stopped Executions](https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
     * + Succeeded: The pipeline execution was completed successfully.
     * + Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see [Superseded Executions](https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded).
     * + Failed: The pipeline execution was not completed successfully.
     */
    public val status: aws.sdk.kotlin.services.codepipeline.model.PipelineExecutionStatus? = builder.status
    /**
     * A summary that contains a description of the pipeline execution status.
     */
    public val statusSummary: kotlin.String? = builder.statusSummary
    /**
     * The interaction or event that started a pipeline execution.
     */
    public val trigger: aws.sdk.kotlin.services.codepipeline.model.ExecutionTrigger? = builder.trigger
    /**
     * A list of pipeline variables used for the pipeline execution.
     */
    public val variables: List<ResolvedPipelineVariable>? = builder.variables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.PipelineExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PipelineExecution(")
        append("artifactRevisions=$artifactRevisions,")
        append("executionMode=$executionMode,")
        append("executionType=$executionType,")
        append("pipelineExecutionId=$pipelineExecutionId,")
        append("pipelineName=$pipelineName,")
        append("pipelineVersion=$pipelineVersion,")
        append("rollbackMetadata=$rollbackMetadata,")
        append("status=$status,")
        append("statusSummary=$statusSummary,")
        append("trigger=$trigger,")
        append("variables=$variables")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactRevisions?.hashCode() ?: 0
        result = 31 * result + (executionMode?.hashCode() ?: 0)
        result = 31 * result + (executionType?.hashCode() ?: 0)
        result = 31 * result + (pipelineExecutionId?.hashCode() ?: 0)
        result = 31 * result + (pipelineName?.hashCode() ?: 0)
        result = 31 * result + (pipelineVersion ?: 0)
        result = 31 * result + (rollbackMetadata?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusSummary?.hashCode() ?: 0)
        result = 31 * result + (trigger?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PipelineExecution

        if (artifactRevisions != other.artifactRevisions) return false
        if (executionMode != other.executionMode) return false
        if (executionType != other.executionType) return false
        if (pipelineExecutionId != other.pipelineExecutionId) return false
        if (pipelineName != other.pipelineName) return false
        if (pipelineVersion != other.pipelineVersion) return false
        if (rollbackMetadata != other.rollbackMetadata) return false
        if (status != other.status) return false
        if (statusSummary != other.statusSummary) return false
        if (trigger != other.trigger) return false
        if (variables != other.variables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.PipelineExecution = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of `ArtifactRevision` objects included in a pipeline execution.
         */
        public var artifactRevisions: List<ArtifactRevision>? = null
        /**
         * The method that the pipeline will use to handle multiple executions. The default mode is SUPERSEDED.
         */
        public var executionMode: aws.sdk.kotlin.services.codepipeline.model.ExecutionMode? = null
        /**
         * The type of the pipeline execution.
         */
        public var executionType: aws.sdk.kotlin.services.codepipeline.model.ExecutionType? = null
        /**
         * The ID of the pipeline execution.
         */
        public var pipelineExecutionId: kotlin.String? = null
        /**
         * The name of the pipeline with the specified pipeline execution.
         */
        public var pipelineName: kotlin.String? = null
        /**
         * The version number of the pipeline with the specified pipeline execution.
         */
        public var pipelineVersion: kotlin.Int? = null
        /**
         * The metadata about the execution pertaining to stage rollback.
         */
        public var rollbackMetadata: aws.sdk.kotlin.services.codepipeline.model.PipelineRollbackMetadata? = null
        /**
         * The status of the pipeline execution.
         * + Cancelled: The pipeline’s definition was updated before the pipeline execution could be completed.
         * + InProgress: The pipeline execution is currently running.
         * + Stopped: The pipeline execution was manually stopped. For more information, see [Stopped Executions](https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
         * + Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see [Stopped Executions](https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
         * + Succeeded: The pipeline execution was completed successfully.
         * + Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see [Superseded Executions](https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded).
         * + Failed: The pipeline execution was not completed successfully.
         */
        public var status: aws.sdk.kotlin.services.codepipeline.model.PipelineExecutionStatus? = null
        /**
         * A summary that contains a description of the pipeline execution status.
         */
        public var statusSummary: kotlin.String? = null
        /**
         * The interaction or event that started a pipeline execution.
         */
        public var trigger: aws.sdk.kotlin.services.codepipeline.model.ExecutionTrigger? = null
        /**
         * A list of pipeline variables used for the pipeline execution.
         */
        public var variables: List<ResolvedPipelineVariable>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.PipelineExecution) : this() {
            this.artifactRevisions = x.artifactRevisions
            this.executionMode = x.executionMode
            this.executionType = x.executionType
            this.pipelineExecutionId = x.pipelineExecutionId
            this.pipelineName = x.pipelineName
            this.pipelineVersion = x.pipelineVersion
            this.rollbackMetadata = x.rollbackMetadata
            this.status = x.status
            this.statusSummary = x.statusSummary
            this.trigger = x.trigger
            this.variables = x.variables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.PipelineExecution = PipelineExecution(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.PipelineRollbackMetadata] inside the given [block]
         */
        public fun rollbackMetadata(block: aws.sdk.kotlin.services.codepipeline.model.PipelineRollbackMetadata.Builder.() -> kotlin.Unit) {
            this.rollbackMetadata = aws.sdk.kotlin.services.codepipeline.model.PipelineRollbackMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ExecutionTrigger] inside the given [block]
         */
        public fun trigger(block: aws.sdk.kotlin.services.codepipeline.model.ExecutionTrigger.Builder.() -> kotlin.Unit) {
            this.trigger = aws.sdk.kotlin.services.codepipeline.model.ExecutionTrigger.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
