// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A type of trigger configuration for Git-based source actions.
 *
 * You can specify the Git configuration trigger type for all third-party Git-based source actions that are supported by the `CodeStarSourceConnection` action type.
 */
public class GitConfiguration private constructor(builder: Builder) {
    /**
     * The field where the repository event that will start the pipeline is specified as pull requests.
     */
    public val pullRequest: List<GitPullRequestFilter>? = builder.pullRequest
    /**
     * The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details.
     */
    public val push: List<GitPushFilter>? = builder.push
    /**
     * The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
     *
     * You can only specify one trigger configuration per source action.
     */
    public val sourceActionName: kotlin.String = requireNotNull(builder.sourceActionName) { "A non-null value must be provided for sourceActionName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.GitConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GitConfiguration(")
        append("pullRequest=$pullRequest,")
        append("push=$push,")
        append("sourceActionName=$sourceActionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = pullRequest?.hashCode() ?: 0
        result = 31 * result + (push?.hashCode() ?: 0)
        result = 31 * result + (sourceActionName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GitConfiguration

        if (pullRequest != other.pullRequest) return false
        if (push != other.push) return false
        if (sourceActionName != other.sourceActionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.GitConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The field where the repository event that will start the pipeline is specified as pull requests.
         */
        public var pullRequest: List<GitPullRequestFilter>? = null
        /**
         * The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details.
         */
        public var push: List<GitPushFilter>? = null
        /**
         * The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
         *
         * You can only specify one trigger configuration per source action.
         */
        public var sourceActionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.GitConfiguration) : this() {
            this.pullRequest = x.pullRequest
            this.push = x.push
            this.sourceActionName = x.sourceActionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.GitConfiguration = GitConfiguration(this)

        internal fun correctErrors(): Builder {
            if (sourceActionName == null) sourceActionName = ""
            return this
        }
    }
}
