// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents information about each property specified in the action configuration, such as the description and key name that display for the customer using the action type.
 */
public class ActionTypeProperty private constructor(builder: Builder) {
    /**
     * The description of the property that is displayed to users.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Whether the configuration property is a key.
     */
    public val key: kotlin.Boolean = builder.key
    /**
     * The property name that is displayed to users.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Whether to omit the field value entered by the customer in the log. If `true`, the value is not saved in CloudTrail logs for the action execution.
     */
    public val noEcho: kotlin.Boolean = builder.noEcho
    /**
     * Whether the configuration property is an optional value.
     */
    public val optional: kotlin.Boolean = builder.optional
    /**
     * Indicates that the property is used with polling. An action type can have up to one queryable property. If it has one, that property must be both required and not secret.
     */
    public val queryable: kotlin.Boolean = builder.queryable

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ActionTypeProperty = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionTypeProperty(")
        append("description=$description,")
        append("key=$key,")
        append("name=$name,")
        append("noEcho=$noEcho,")
        append("optional=$optional,")
        append("queryable=$queryable")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (key.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (noEcho.hashCode())
        result = 31 * result + (optional.hashCode())
        result = 31 * result + (queryable.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionTypeProperty

        if (description != other.description) return false
        if (key != other.key) return false
        if (name != other.name) return false
        if (noEcho != other.noEcho) return false
        if (optional != other.optional) return false
        if (queryable != other.queryable) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ActionTypeProperty = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description of the property that is displayed to users.
         */
        public var description: kotlin.String? = null
        /**
         * Whether the configuration property is a key.
         */
        public var key: kotlin.Boolean = false
        /**
         * The property name that is displayed to users.
         */
        public var name: kotlin.String? = null
        /**
         * Whether to omit the field value entered by the customer in the log. If `true`, the value is not saved in CloudTrail logs for the action execution.
         */
        public var noEcho: kotlin.Boolean = false
        /**
         * Whether the configuration property is an optional value.
         */
        public var optional: kotlin.Boolean = false
        /**
         * Indicates that the property is used with polling. An action type can have up to one queryable property. If it has one, that property must be both required and not secret.
         */
        public var queryable: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ActionTypeProperty) : this() {
            this.description = x.description
            this.key = x.key
            this.name = x.name
            this.noEcho = x.noEcho
            this.optional = x.optional
            this.queryable = x.queryable
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ActionTypeProperty = ActionTypeProperty(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
