// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The parameters for the action type definition that are provided when the action type is created or updated.
 */
public class ActionTypeDeclaration private constructor(builder: Builder) {
    /**
     * The description for the action type to be updated.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Information about the executor for an action type that was created with any supported integration model.
     */
    public val executor: aws.sdk.kotlin.services.codepipeline.model.ActionTypeExecutor? = builder.executor
    /**
     * The action category, owner, provider, and version of the action type to be updated.
     */
    public val id: aws.sdk.kotlin.services.codepipeline.model.ActionTypeIdentifier? = builder.id
    /**
     * Details for the artifacts, such as application files, to be worked on by the action. For example, the minimum and maximum number of input artifacts allowed.
     */
    public val inputArtifactDetails: aws.sdk.kotlin.services.codepipeline.model.ActionTypeArtifactDetails? = builder.inputArtifactDetails
    /**
     * Details for the output artifacts, such as a built application, that are the result of the action. For example, the minimum and maximum number of output artifacts allowed.
     */
    public val outputArtifactDetails: aws.sdk.kotlin.services.codepipeline.model.ActionTypeArtifactDetails? = builder.outputArtifactDetails
    /**
     * Details identifying the accounts with permissions to use the action type.
     */
    public val permissions: aws.sdk.kotlin.services.codepipeline.model.ActionTypePermissions? = builder.permissions
    /**
     * The properties of the action type to be updated.
     */
    public val properties: List<ActionTypeProperty>? = builder.properties
    /**
     * The links associated with the action type to be updated.
     */
    public val urls: aws.sdk.kotlin.services.codepipeline.model.ActionTypeUrls? = builder.urls

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ActionTypeDeclaration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionTypeDeclaration(")
        append("description=$description,")
        append("executor=$executor,")
        append("id=$id,")
        append("inputArtifactDetails=$inputArtifactDetails,")
        append("outputArtifactDetails=$outputArtifactDetails,")
        append("permissions=$permissions,")
        append("properties=$properties,")
        append("urls=$urls")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (executor?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (inputArtifactDetails?.hashCode() ?: 0)
        result = 31 * result + (outputArtifactDetails?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        result = 31 * result + (urls?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionTypeDeclaration

        if (description != other.description) return false
        if (executor != other.executor) return false
        if (id != other.id) return false
        if (inputArtifactDetails != other.inputArtifactDetails) return false
        if (outputArtifactDetails != other.outputArtifactDetails) return false
        if (permissions != other.permissions) return false
        if (properties != other.properties) return false
        if (urls != other.urls) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ActionTypeDeclaration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description for the action type to be updated.
         */
        public var description: kotlin.String? = null
        /**
         * Information about the executor for an action type that was created with any supported integration model.
         */
        public var executor: aws.sdk.kotlin.services.codepipeline.model.ActionTypeExecutor? = null
        /**
         * The action category, owner, provider, and version of the action type to be updated.
         */
        public var id: aws.sdk.kotlin.services.codepipeline.model.ActionTypeIdentifier? = null
        /**
         * Details for the artifacts, such as application files, to be worked on by the action. For example, the minimum and maximum number of input artifacts allowed.
         */
        public var inputArtifactDetails: aws.sdk.kotlin.services.codepipeline.model.ActionTypeArtifactDetails? = null
        /**
         * Details for the output artifacts, such as a built application, that are the result of the action. For example, the minimum and maximum number of output artifacts allowed.
         */
        public var outputArtifactDetails: aws.sdk.kotlin.services.codepipeline.model.ActionTypeArtifactDetails? = null
        /**
         * Details identifying the accounts with permissions to use the action type.
         */
        public var permissions: aws.sdk.kotlin.services.codepipeline.model.ActionTypePermissions? = null
        /**
         * The properties of the action type to be updated.
         */
        public var properties: List<ActionTypeProperty>? = null
        /**
         * The links associated with the action type to be updated.
         */
        public var urls: aws.sdk.kotlin.services.codepipeline.model.ActionTypeUrls? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ActionTypeDeclaration) : this() {
            this.description = x.description
            this.executor = x.executor
            this.id = x.id
            this.inputArtifactDetails = x.inputArtifactDetails
            this.outputArtifactDetails = x.outputArtifactDetails
            this.permissions = x.permissions
            this.properties = x.properties
            this.urls = x.urls
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ActionTypeDeclaration = ActionTypeDeclaration(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionTypeExecutor] inside the given [block]
         */
        public fun executor(block: aws.sdk.kotlin.services.codepipeline.model.ActionTypeExecutor.Builder.() -> kotlin.Unit) {
            this.executor = aws.sdk.kotlin.services.codepipeline.model.ActionTypeExecutor.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionTypeIdentifier] inside the given [block]
         */
        public fun id(block: aws.sdk.kotlin.services.codepipeline.model.ActionTypeIdentifier.Builder.() -> kotlin.Unit) {
            this.id = aws.sdk.kotlin.services.codepipeline.model.ActionTypeIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionTypeArtifactDetails] inside the given [block]
         */
        public fun inputArtifactDetails(block: aws.sdk.kotlin.services.codepipeline.model.ActionTypeArtifactDetails.Builder.() -> kotlin.Unit) {
            this.inputArtifactDetails = aws.sdk.kotlin.services.codepipeline.model.ActionTypeArtifactDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionTypeArtifactDetails] inside the given [block]
         */
        public fun outputArtifactDetails(block: aws.sdk.kotlin.services.codepipeline.model.ActionTypeArtifactDetails.Builder.() -> kotlin.Unit) {
            this.outputArtifactDetails = aws.sdk.kotlin.services.codepipeline.model.ActionTypeArtifactDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionTypePermissions] inside the given [block]
         */
        public fun permissions(block: aws.sdk.kotlin.services.codepipeline.model.ActionTypePermissions.Builder.() -> kotlin.Unit) {
            this.permissions = aws.sdk.kotlin.services.codepipeline.model.ActionTypePermissions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionTypeUrls] inside the given [block]
         */
        public fun urls(block: aws.sdk.kotlin.services.codepipeline.model.ActionTypeUrls.Builder.() -> kotlin.Unit) {
            this.urls = aws.sdk.kotlin.services.codepipeline.model.ActionTypeUrls.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
