// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codepipeline.model.CodePipelineException
import aws.sdk.kotlin.services.codepipeline.model.GetPipelineStateResponse
import aws.sdk.kotlin.services.codepipeline.model.StageState
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetPipelineStateOperationDeserializer: HttpDeserialize<GetPipelineStateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPipelineStateResponse {
        if (!response.status.isSuccess()) {
            throwGetPipelineStateError(context, response)
        }
        val builder = GetPipelineStateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPipelineStateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPipelineStateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodePipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "PipelineNotFoundException" -> PipelineNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodePipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPipelineStateOperationBody(builder: GetPipelineStateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("created"))
    val PIPELINENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("pipelineName"))
    val PIPELINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("pipelineVersion"))
    val STAGESTATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("stageStates"))
    val UPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updated"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATED_DESCRIPTOR)
        field(PIPELINENAME_DESCRIPTOR)
        field(PIPELINEVERSION_DESCRIPTOR)
        field(STAGESTATES_DESCRIPTOR)
        field(UPDATED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATED_DESCRIPTOR.index -> builder.created = deserializeString().let { Instant.fromEpochSeconds(it) }
                PIPELINENAME_DESCRIPTOR.index -> builder.pipelineName = deserializeString()
                PIPELINEVERSION_DESCRIPTOR.index -> builder.pipelineVersion = deserializeInt()
                STAGESTATES_DESCRIPTOR.index -> builder.stageStates =
                    deserializer.deserializeList(STAGESTATES_DESCRIPTOR) {
                        val col0 = mutableListOf<StageState>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeStageStateDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UPDATED_DESCRIPTOR.index -> builder.updated = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
