// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codepipeline.model.CodePipelineException
import aws.sdk.kotlin.services.codepipeline.model.DeregisterWebhookWithThirdPartyResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeregisterWebhookWithThirdPartyOperationDeserializer: HttpDeserialize<DeregisterWebhookWithThirdPartyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeregisterWebhookWithThirdPartyResponse {
        if (!response.status.isSuccess()) {
            throwDeregisterWebhookWithThirdPartyError(context, response)
        }
        val builder = DeregisterWebhookWithThirdPartyResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeregisterWebhookWithThirdPartyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodePipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        "WebhookNotFoundException" -> WebhookNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodePipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
