// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codepipeline.model.CodePipelineException
import aws.sdk.kotlin.services.codepipeline.model.DeleteWebhookResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteWebhookOperationDeserializer: HttpDeserialize<DeleteWebhookResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteWebhookResponse {
        if (!response.status.isSuccess()) {
            throwDeleteWebhookError(context, response)
        }
        val builder = DeleteWebhookResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteWebhookError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodePipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodePipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
