// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * The event criteria that specify when a webhook notification is sent to your URL.
 */
public class WebhookFilterRule private constructor(builder: Builder) {
    /**
     * A JsonPath expression that is applied to the body/payload of the webhook. The value selected by the JsonPath expression must match the value specified in the `MatchEquals` field. Otherwise, the request is ignored. For more information, see [Java JsonPath implementation](https://github.com/json-path/JsonPath) in GitHub.
     */
    public val jsonPath: kotlin.String? = builder.jsonPath
    /**
     * The value selected by the `JsonPath` expression must match what is supplied in the `MatchEquals` field. Otherwise, the request is ignored. Properties from the target action configuration can be included as placeholders in this value by surrounding the action configuration key with curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the target action has an action configuration property called "Branch" with a value of "master", the `MatchEquals` value is evaluated as "refs/heads/master". For a list of action configuration properties for built-in action types, see [Pipeline Structure Reference Action Requirements](https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements).
     */
    public val matchEquals: kotlin.String? = builder.matchEquals

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.WebhookFilterRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WebhookFilterRule(")
        append("jsonPath=$jsonPath,")
        append("matchEquals=$matchEquals")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = jsonPath?.hashCode() ?: 0
        result = 31 * result + (matchEquals?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WebhookFilterRule

        if (jsonPath != other.jsonPath) return false
        if (matchEquals != other.matchEquals) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.WebhookFilterRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A JsonPath expression that is applied to the body/payload of the webhook. The value selected by the JsonPath expression must match the value specified in the `MatchEquals` field. Otherwise, the request is ignored. For more information, see [Java JsonPath implementation](https://github.com/json-path/JsonPath) in GitHub.
         */
        public var jsonPath: kotlin.String? = null
        /**
         * The value selected by the `JsonPath` expression must match what is supplied in the `MatchEquals` field. Otherwise, the request is ignored. Properties from the target action configuration can be included as placeholders in this value by surrounding the action configuration key with curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the target action has an action configuration property called "Branch" with a value of "master", the `MatchEquals` value is evaluated as "refs/heads/master". For a list of action configuration properties for built-in action types, see [Pipeline Structure Reference Action Requirements](https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements).
         */
        public var matchEquals: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.WebhookFilterRule) : this() {
            this.jsonPath = x.jsonPath
            this.matchEquals = x.matchEquals
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.WebhookFilterRule = WebhookFilterRule(this)
    }
}
