// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * Represents the structure of actions and stages to be performed in the pipeline.
 */
public class PipelineDeclaration private constructor(builder: Builder) {
    /**
     * Represents information about the S3 bucket where artifacts are stored for the pipeline.
     *
     * You must include either `artifactStore` or `artifactStores` in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use `artifactStores`.
     */
    public val artifactStore: aws.sdk.kotlin.services.codepipeline.model.ArtifactStore? = builder.artifactStore
    /**
     * A mapping of `artifactStore` objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
     *
     * You must include either `artifactStore` or `artifactStores` in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use `artifactStores`.
     */
    public val artifactStores: Map<String, ArtifactStore>? = builder.artifactStores
    /**
     * The name of the pipeline.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform actions with no `actionRoleArn`, or to use to assume roles for actions with an `actionRoleArn`.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The stage in which to perform the action.
     */
    public val stages: List<StageDeclaration>? = builder.stages
    /**
     * The version number of the pipeline. A new pipeline always has a version number of 1. This number is incremented when a pipeline is updated.
     */
    public val version: kotlin.Int? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.PipelineDeclaration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PipelineDeclaration(")
        append("artifactStore=$artifactStore,")
        append("artifactStores=$artifactStores,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("stages=$stages,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactStore?.hashCode() ?: 0
        result = 31 * result + (artifactStores?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stages?.hashCode() ?: 0)
        result = 31 * result + (version ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PipelineDeclaration

        if (artifactStore != other.artifactStore) return false
        if (artifactStores != other.artifactStores) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (stages != other.stages) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.PipelineDeclaration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Represents information about the S3 bucket where artifacts are stored for the pipeline.
         *
         * You must include either `artifactStore` or `artifactStores` in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use `artifactStores`.
         */
        public var artifactStore: aws.sdk.kotlin.services.codepipeline.model.ArtifactStore? = null
        /**
         * A mapping of `artifactStore` objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
         *
         * You must include either `artifactStore` or `artifactStores` in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use `artifactStores`.
         */
        public var artifactStores: Map<String, ArtifactStore>? = null
        /**
         * The name of the pipeline.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform actions with no `actionRoleArn`, or to use to assume roles for actions with an `actionRoleArn`.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The stage in which to perform the action.
         */
        public var stages: List<StageDeclaration>? = null
        /**
         * The version number of the pipeline. A new pipeline always has a version number of 1. This number is incremented when a pipeline is updated.
         */
        public var version: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.PipelineDeclaration) : this() {
            this.artifactStore = x.artifactStore
            this.artifactStores = x.artifactStores
            this.name = x.name
            this.roleArn = x.roleArn
            this.stages = x.stages
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.PipelineDeclaration = PipelineDeclaration(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ArtifactStore] inside the given [block]
         */
        public fun artifactStore(block: aws.sdk.kotlin.services.codepipeline.model.ArtifactStore.Builder.() -> kotlin.Unit) {
            this.artifactStore = aws.sdk.kotlin.services.codepipeline.model.ArtifactStore.invoke(block)
        }
    }
}
