// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * Represents the input of a `DisableStageTransition` action.
 */
public class DisableStageTransitionRequest private constructor(builder: Builder) {
    /**
     * The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
     */
    public val pipelineName: kotlin.String? = builder.pipelineName
    /**
     * The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The name of the stage where you want to disable the inbound or outbound transition of artifacts.
     */
    public val stageName: kotlin.String? = builder.stageName
    /**
     * Specifies whether artifacts are prevented from transitioning into the stage and being processed by the actions in that stage (inbound), or prevented from transitioning from the stage after they have been processed by the actions in that stage (outbound).
     */
    public val transitionType: aws.sdk.kotlin.services.codepipeline.model.StageTransitionType? = builder.transitionType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.DisableStageTransitionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DisableStageTransitionRequest(")
        append("pipelineName=$pipelineName,")
        append("reason=$reason,")
        append("stageName=$stageName,")
        append("transitionType=$transitionType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = pipelineName?.hashCode() ?: 0
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (transitionType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DisableStageTransitionRequest

        if (pipelineName != other.pipelineName) return false
        if (reason != other.reason) return false
        if (stageName != other.stageName) return false
        if (transitionType != other.transitionType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.DisableStageTransitionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
         */
        public var pipelineName: kotlin.String? = null
        /**
         * The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.
         */
        public var reason: kotlin.String? = null
        /**
         * The name of the stage where you want to disable the inbound or outbound transition of artifacts.
         */
        public var stageName: kotlin.String? = null
        /**
         * Specifies whether artifacts are prevented from transitioning into the stage and being processed by the actions in that stage (inbound), or prevented from transitioning from the stage after they have been processed by the actions in that stage (outbound).
         */
        public var transitionType: aws.sdk.kotlin.services.codepipeline.model.StageTransitionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.DisableStageTransitionRequest) : this() {
            this.pipelineName = x.pipelineName
            this.reason = x.reason
            this.stageName = x.stageName
            this.transitionType = x.transitionType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.DisableStageTransitionRequest = DisableStageTransitionRequest(this)
    }
}
