// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents revision details of an artifact.
 */
public class ArtifactRevision private constructor(builder: Builder) {
    /**
     * The date and time when the most recent revision of the artifact was created, in timestamp format.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The name of an artifact. This name might be system-generated, such as "MyApp", or defined by the user when an action is created.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An additional identifier for a revision, such as a commit date or, for artifacts stored in Amazon S3 buckets, the ETag value.
     */
    public val revisionChangeIdentifier: kotlin.String? = builder.revisionChangeIdentifier
    /**
     * The revision ID of the artifact.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a `codepipeline-artifact-revision-summary` key specified in the object metadata.
     */
    public val revisionSummary: kotlin.String? = builder.revisionSummary
    /**
     * The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.
     */
    public val revisionUrl: kotlin.String? = builder.revisionUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ArtifactRevision = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ArtifactRevision(")
        append("created=$created,")
        append("name=$name,")
        append("revisionChangeIdentifier=$revisionChangeIdentifier,")
        append("revisionId=$revisionId,")
        append("revisionSummary=$revisionSummary,")
        append("revisionUrl=$revisionUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = created?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (revisionChangeIdentifier?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (revisionSummary?.hashCode() ?: 0)
        result = 31 * result + (revisionUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ArtifactRevision

        if (created != other.created) return false
        if (name != other.name) return false
        if (revisionChangeIdentifier != other.revisionChangeIdentifier) return false
        if (revisionId != other.revisionId) return false
        if (revisionSummary != other.revisionSummary) return false
        if (revisionUrl != other.revisionUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ArtifactRevision = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time when the most recent revision of the artifact was created, in timestamp format.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of an artifact. This name might be system-generated, such as "MyApp", or defined by the user when an action is created.
         */
        public var name: kotlin.String? = null
        /**
         * An additional identifier for a revision, such as a commit date or, for artifacts stored in Amazon S3 buckets, the ETag value.
         */
        public var revisionChangeIdentifier: kotlin.String? = null
        /**
         * The revision ID of the artifact.
         */
        public var revisionId: kotlin.String? = null
        /**
         * Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a `codepipeline-artifact-revision-summary` key specified in the object metadata.
         */
        public var revisionSummary: kotlin.String? = null
        /**
         * The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.
         */
        public var revisionUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ArtifactRevision) : this() {
            this.created = x.created
            this.name = x.name
            this.revisionChangeIdentifier = x.revisionChangeIdentifier
            this.revisionId = x.revisionId
            this.revisionSummary = x.revisionSummary
            this.revisionUrl = x.revisionUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ArtifactRevision = ArtifactRevision(this)
    }
}
