// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * Returns information about URLs for web pages that display to customers as links on the pipeline view, such as an external configuration page for the action type.
 */
public class ActionTypeUrls private constructor(builder: Builder) {
    /**
     * The URL returned to the CodePipeline console that contains a link to the page where customers can configure the external action.
     */
    public val configurationUrl: kotlin.String? = builder.configurationUrl
    /**
     * The URL returned to the CodePipeline console that provides a deep link to the resources of the external system, such as a status page. This link is provided as part of the action display in the pipeline.
     */
    public val entityUrlTemplate: kotlin.String? = builder.entityUrlTemplate
    /**
     * The link to an execution page for the action type in progress. For example, for a CodeDeploy action, this link is shown on the pipeline view page in the CodePipeline console, and it links to a CodeDeploy status page.
     */
    public val executionUrlTemplate: kotlin.String? = builder.executionUrlTemplate
    /**
     * The URL returned to the CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
     */
    public val revisionUrlTemplate: kotlin.String? = builder.revisionUrlTemplate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ActionTypeUrls = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionTypeUrls(")
        append("configurationUrl=$configurationUrl,")
        append("entityUrlTemplate=$entityUrlTemplate,")
        append("executionUrlTemplate=$executionUrlTemplate,")
        append("revisionUrlTemplate=$revisionUrlTemplate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationUrl?.hashCode() ?: 0
        result = 31 * result + (entityUrlTemplate?.hashCode() ?: 0)
        result = 31 * result + (executionUrlTemplate?.hashCode() ?: 0)
        result = 31 * result + (revisionUrlTemplate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionTypeUrls

        if (configurationUrl != other.configurationUrl) return false
        if (entityUrlTemplate != other.entityUrlTemplate) return false
        if (executionUrlTemplate != other.executionUrlTemplate) return false
        if (revisionUrlTemplate != other.revisionUrlTemplate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ActionTypeUrls = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The URL returned to the CodePipeline console that contains a link to the page where customers can configure the external action.
         */
        public var configurationUrl: kotlin.String? = null
        /**
         * The URL returned to the CodePipeline console that provides a deep link to the resources of the external system, such as a status page. This link is provided as part of the action display in the pipeline.
         */
        public var entityUrlTemplate: kotlin.String? = null
        /**
         * The link to an execution page for the action type in progress. For example, for a CodeDeploy action, this link is shown on the pipeline view page in the CodePipeline console, and it links to a CodeDeploy status page.
         */
        public var executionUrlTemplate: kotlin.String? = null
        /**
         * The URL returned to the CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
         */
        public var revisionUrlTemplate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ActionTypeUrls) : this() {
            this.configurationUrl = x.configurationUrl
            this.entityUrlTemplate = x.entityUrlTemplate
            this.executionUrlTemplate = x.executionUrlTemplate
            this.revisionUrlTemplate = x.revisionUrlTemplate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ActionTypeUrls = ActionTypeUrls(this)
    }
}
