// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * Represents information about an action type.
 */
public class ActionTypeId private constructor(builder: Builder) {
    /**
     * A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the following values.
     * + Source
     * + Build
     * + Test
     * + Deploy
     * + Invoke
     * + Approval
     */
    public val category: aws.sdk.kotlin.services.codepipeline.model.ActionCategory? = builder.category
    /**
     * The creator of the action being called. There are three valid values for the `Owner` field in the action category section within your pipeline structure: `AWS`, `ThirdParty`, and `Custom`. For more information, see [Valid Action Types and Providers in CodePipeline](https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers).
     */
    public val owner: aws.sdk.kotlin.services.codepipeline.model.ActionOwner? = builder.owner
    /**
     * The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of AWS CodeDeploy, which would be specified as CodeDeploy. For more information, see [Valid Action Types and Providers in CodePipeline](https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers).
     */
    public val provider: kotlin.String? = builder.provider
    /**
     * A string that describes the action version.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ActionTypeId = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionTypeId(")
        append("category=$category,")
        append("owner=$owner,")
        append("provider=$provider,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = category?.hashCode() ?: 0
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (provider?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionTypeId

        if (category != other.category) return false
        if (owner != other.owner) return false
        if (provider != other.provider) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ActionTypeId = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the following values.
         * + Source
         * + Build
         * + Test
         * + Deploy
         * + Invoke
         * + Approval
         */
        public var category: aws.sdk.kotlin.services.codepipeline.model.ActionCategory? = null
        /**
         * The creator of the action being called. There are three valid values for the `Owner` field in the action category section within your pipeline structure: `AWS`, `ThirdParty`, and `Custom`. For more information, see [Valid Action Types and Providers in CodePipeline](https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers).
         */
        public var owner: aws.sdk.kotlin.services.codepipeline.model.ActionOwner? = null
        /**
         * The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of AWS CodeDeploy, which would be specified as CodeDeploy. For more information, see [Valid Action Types and Providers in CodePipeline](https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers).
         */
        public var provider: kotlin.String? = null
        /**
         * A string that describes the action version.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ActionTypeId) : this() {
            this.category = x.category
            this.owner = x.owner
            this.provider = x.provider
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ActionTypeId = ActionTypeId(this)
    }
}
