// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.codepipeline.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.codepipeline.endpoints.EndpointProvider
import aws.sdk.kotlin.services.codepipeline.model.AcknowledgeJobRequest
import aws.sdk.kotlin.services.codepipeline.model.AcknowledgeJobResponse
import aws.sdk.kotlin.services.codepipeline.model.AcknowledgeThirdPartyJobRequest
import aws.sdk.kotlin.services.codepipeline.model.AcknowledgeThirdPartyJobResponse
import aws.sdk.kotlin.services.codepipeline.model.CreateCustomActionTypeRequest
import aws.sdk.kotlin.services.codepipeline.model.CreateCustomActionTypeResponse
import aws.sdk.kotlin.services.codepipeline.model.CreatePipelineRequest
import aws.sdk.kotlin.services.codepipeline.model.CreatePipelineResponse
import aws.sdk.kotlin.services.codepipeline.model.DeleteCustomActionTypeRequest
import aws.sdk.kotlin.services.codepipeline.model.DeleteCustomActionTypeResponse
import aws.sdk.kotlin.services.codepipeline.model.DeletePipelineRequest
import aws.sdk.kotlin.services.codepipeline.model.DeletePipelineResponse
import aws.sdk.kotlin.services.codepipeline.model.DeleteWebhookRequest
import aws.sdk.kotlin.services.codepipeline.model.DeleteWebhookResponse
import aws.sdk.kotlin.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest
import aws.sdk.kotlin.services.codepipeline.model.DeregisterWebhookWithThirdPartyResponse
import aws.sdk.kotlin.services.codepipeline.model.DisableStageTransitionRequest
import aws.sdk.kotlin.services.codepipeline.model.DisableStageTransitionResponse
import aws.sdk.kotlin.services.codepipeline.model.EnableStageTransitionRequest
import aws.sdk.kotlin.services.codepipeline.model.EnableStageTransitionResponse
import aws.sdk.kotlin.services.codepipeline.model.GetActionTypeRequest
import aws.sdk.kotlin.services.codepipeline.model.GetActionTypeResponse
import aws.sdk.kotlin.services.codepipeline.model.GetJobDetailsRequest
import aws.sdk.kotlin.services.codepipeline.model.GetJobDetailsResponse
import aws.sdk.kotlin.services.codepipeline.model.GetPipelineExecutionRequest
import aws.sdk.kotlin.services.codepipeline.model.GetPipelineExecutionResponse
import aws.sdk.kotlin.services.codepipeline.model.GetPipelineRequest
import aws.sdk.kotlin.services.codepipeline.model.GetPipelineResponse
import aws.sdk.kotlin.services.codepipeline.model.GetPipelineStateRequest
import aws.sdk.kotlin.services.codepipeline.model.GetPipelineStateResponse
import aws.sdk.kotlin.services.codepipeline.model.GetThirdPartyJobDetailsRequest
import aws.sdk.kotlin.services.codepipeline.model.GetThirdPartyJobDetailsResponse
import aws.sdk.kotlin.services.codepipeline.model.ListActionExecutionsRequest
import aws.sdk.kotlin.services.codepipeline.model.ListActionExecutionsResponse
import aws.sdk.kotlin.services.codepipeline.model.ListActionTypesRequest
import aws.sdk.kotlin.services.codepipeline.model.ListActionTypesResponse
import aws.sdk.kotlin.services.codepipeline.model.ListPipelineExecutionsRequest
import aws.sdk.kotlin.services.codepipeline.model.ListPipelineExecutionsResponse
import aws.sdk.kotlin.services.codepipeline.model.ListPipelinesRequest
import aws.sdk.kotlin.services.codepipeline.model.ListPipelinesResponse
import aws.sdk.kotlin.services.codepipeline.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.codepipeline.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.codepipeline.model.ListWebhooksRequest
import aws.sdk.kotlin.services.codepipeline.model.ListWebhooksResponse
import aws.sdk.kotlin.services.codepipeline.model.PollForJobsRequest
import aws.sdk.kotlin.services.codepipeline.model.PollForJobsResponse
import aws.sdk.kotlin.services.codepipeline.model.PollForThirdPartyJobsRequest
import aws.sdk.kotlin.services.codepipeline.model.PollForThirdPartyJobsResponse
import aws.sdk.kotlin.services.codepipeline.model.PutActionRevisionRequest
import aws.sdk.kotlin.services.codepipeline.model.PutActionRevisionResponse
import aws.sdk.kotlin.services.codepipeline.model.PutApprovalResultRequest
import aws.sdk.kotlin.services.codepipeline.model.PutApprovalResultResponse
import aws.sdk.kotlin.services.codepipeline.model.PutJobFailureResultRequest
import aws.sdk.kotlin.services.codepipeline.model.PutJobFailureResultResponse
import aws.sdk.kotlin.services.codepipeline.model.PutJobSuccessResultRequest
import aws.sdk.kotlin.services.codepipeline.model.PutJobSuccessResultResponse
import aws.sdk.kotlin.services.codepipeline.model.PutThirdPartyJobFailureResultRequest
import aws.sdk.kotlin.services.codepipeline.model.PutThirdPartyJobFailureResultResponse
import aws.sdk.kotlin.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest
import aws.sdk.kotlin.services.codepipeline.model.PutThirdPartyJobSuccessResultResponse
import aws.sdk.kotlin.services.codepipeline.model.PutWebhookRequest
import aws.sdk.kotlin.services.codepipeline.model.PutWebhookResponse
import aws.sdk.kotlin.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest
import aws.sdk.kotlin.services.codepipeline.model.RegisterWebhookWithThirdPartyResponse
import aws.sdk.kotlin.services.codepipeline.model.RetryStageExecutionRequest
import aws.sdk.kotlin.services.codepipeline.model.RetryStageExecutionResponse
import aws.sdk.kotlin.services.codepipeline.model.StartPipelineExecutionRequest
import aws.sdk.kotlin.services.codepipeline.model.StartPipelineExecutionResponse
import aws.sdk.kotlin.services.codepipeline.model.StopPipelineExecutionRequest
import aws.sdk.kotlin.services.codepipeline.model.StopPipelineExecutionResponse
import aws.sdk.kotlin.services.codepipeline.model.TagResourceRequest
import aws.sdk.kotlin.services.codepipeline.model.TagResourceResponse
import aws.sdk.kotlin.services.codepipeline.model.UntagResourceRequest
import aws.sdk.kotlin.services.codepipeline.model.UntagResourceResponse
import aws.sdk.kotlin.services.codepipeline.model.UpdateActionTypeRequest
import aws.sdk.kotlin.services.codepipeline.model.UpdateActionTypeResponse
import aws.sdk.kotlin.services.codepipeline.model.UpdatePipelineRequest
import aws.sdk.kotlin.services.codepipeline.model.UpdatePipelineResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * # AWS CodePipeline
 * **Overview**
 *
 * This is the AWS CodePipeline API Reference. This guide provides descriptions of the actions and data types for AWS CodePipeline. Some functionality for your pipeline can only be configured through the API. For more information, see the [AWS CodePipeline User Guide](https://docs.aws.amazon.com/codepipeline/latest/userguide/welcome.html).
 *
 * You can use the AWS CodePipeline API to work with pipelines, stages, actions, and transitions.
 *
 * *Pipelines* are models of automated release processes. Each pipeline is uniquely named, and consists of stages, actions, and transitions.
 *
 * You can work with pipelines by calling:
 * + CreatePipeline, which creates a uniquely named pipeline.
 * + DeletePipeline, which deletes the specified pipeline.
 * + GetPipeline, which returns information about the pipeline structure and pipeline metadata, including the pipeline Amazon Resource Name (ARN).
 * + GetPipelineExecution, which returns information about a specific execution of a pipeline.
 * + GetPipelineState, which returns information about the current state of the stages and actions of a pipeline.
 * + ListActionExecutions, which returns action-level details for past executions. The details include full stage and action-level details, including individual action duration, status, any errors that occurred during the execution, and input and output artifact location details.
 * + ListPipelines, which gets a summary of all of the pipelines associated with your account.
 * + ListPipelineExecutions, which gets a summary of the most recent executions for a pipeline.
 * + StartPipelineExecution, which runs the most recent revision of an artifact through the pipeline.
 * + StopPipelineExecution, which stops the specified pipeline execution from continuing through the pipeline.
 * + UpdatePipeline, which updates a pipeline with edits or changes to the structure of the pipeline.
 *
 * Pipelines include *stages*. Each stage contains one or more actions that must complete before the next stage begins. A stage results in success or failure. If a stage fails, the pipeline stops at that stage and remains stopped until either a new version of an artifact appears in the source location, or a user takes action to rerun the most recent artifact through the pipeline. You can call GetPipelineState, which displays the status of a pipeline, including the status of stages in the pipeline, or GetPipeline, which returns the entire structure of the pipeline, including the stages of that pipeline. For more information about the structure of stages and actions, see [AWS CodePipeline Pipeline Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-structure.html).
 *
 * Pipeline stages include *actions* that are categorized into categories such as source or build actions performed in a stage of a pipeline. For example, you can use a source action to import artifacts into a pipeline from a source such as Amazon S3. Like stages, you do not work with actions directly in most cases, but you do define and interact with actions when working with pipeline operations such as CreatePipeline and GetPipelineState. Valid action categories are:
 * + Source
 * + Build
 * + Test
 * + Deploy
 * + Approval
 * + Invoke
 *
 * Pipelines also include *transitions*, which allow the transition of artifacts from one stage to the next in a pipeline after the actions in one stage complete.
 *
 * You can work with transitions by calling:
 * + DisableStageTransition, which prevents artifacts from transitioning to the next stage in a pipeline.
 * + EnableStageTransition, which enables transition of artifacts between stages in a pipeline.
 *
 * **Using the API to integrate with AWS CodePipeline**
 *
 * For third-party integrators or developers who want to create their own integrations with AWS CodePipeline, the expected sequence varies from the standard API user. To integrate with AWS CodePipeline, developers need to work with the following items:
 *
 * **Jobs**, which are instances of an action. For example, a job for a source action might import a revision of an artifact from a source.
 *
 * You can work with jobs by calling:
 * + AcknowledgeJob, which confirms whether a job worker has received the specified job.
 * + GetJobDetails, which returns the details of a job.
 * + PollForJobs, which determines whether there are any jobs to act on.
 * + PutJobFailureResult, which provides details of a job failure.
 * + PutJobSuccessResult, which provides details of a job success.
 *
 * **Third party jobs**, which are instances of an action created by a partner action and integrated into AWS CodePipeline. Partner actions are created by members of the AWS Partner Network.
 *
 * You can work with third party jobs by calling:
 * + AcknowledgeThirdPartyJob, which confirms whether a job worker has received the specified job.
 * + GetThirdPartyJobDetails, which requests the details of a job for a partner action.
 * + PollForThirdPartyJobs, which determines whether there are any jobs to act on.
 * + PutThirdPartyJobFailureResult, which provides details of a job failure.
 * + PutThirdPartyJobSuccessResult, which provides details of a job success.
 */
public interface CodePipelineClient : SdkClient {

    override val serviceName: String
        get() = "CodePipeline"
    /**
     * CodePipelineClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CodePipelineClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CodePipelineClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CodePipelineClient = DefaultCodePipelineClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "CodePipeline")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, IdempotencyTokenConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Returns information about a specified job and whether that job has been received by the job worker. Used for custom actions only.
     */
    public suspend fun acknowledgeJob(input: AcknowledgeJobRequest): AcknowledgeJobResponse

    /**
     * Confirms a job worker has received the specified job. Used for partner actions only.
     */
    public suspend fun acknowledgeThirdPartyJob(input: AcknowledgeThirdPartyJobRequest): AcknowledgeThirdPartyJobResponse

    /**
     * Creates a new custom action that can be used in all pipelines associated with the AWS account. Only used for custom actions.
     */
    public suspend fun createCustomActionType(input: CreateCustomActionTypeRequest): CreateCustomActionTypeResponse

    /**
     * Creates a pipeline.
     *
     * In the pipeline structure, you must include either `artifactStore` or `artifactStores` in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use `artifactStores`.
     */
    public suspend fun createPipeline(input: CreatePipelineRequest): CreatePipelineResponse

    /**
     * Marks a custom action as deleted. `PollForJobs` for the custom action fails after the action is marked for deletion. Used for custom actions only.
     *
     * To re-create a custom action after it has been deleted you must use a string in the version field that has never been used before. This string can be an incremented version number, for example. To restore a deleted custom action, use a JSON file that is identical to the deleted action, including the original string in the version field.
     */
    public suspend fun deleteCustomActionType(input: DeleteCustomActionTypeRequest): DeleteCustomActionTypeResponse

    /**
     * Deletes the specified pipeline.
     */
    public suspend fun deletePipeline(input: DeletePipelineRequest): DeletePipelineResponse

    /**
     * Deletes a previously created webhook by name. Deleting the webhook stops AWS CodePipeline from starting a pipeline every time an external event occurs. The API returns successfully when trying to delete a webhook that is already deleted. If a deleted webhook is re-created by calling PutWebhook with the same name, it will have a different URL.
     */
    public suspend fun deleteWebhook(input: DeleteWebhookRequest): DeleteWebhookResponse

    /**
     * Removes the connection between the webhook that was created by CodePipeline and the external tool with events to be detected. Currently supported only for webhooks that target an action type of GitHub.
     */
    public suspend fun deregisterWebhookWithThirdParty(input: DeregisterWebhookWithThirdPartyRequest = DeregisterWebhookWithThirdPartyRequest {}): DeregisterWebhookWithThirdPartyResponse

    /**
     * Prevents artifacts in a pipeline from transitioning to the next stage in the pipeline.
     */
    public suspend fun disableStageTransition(input: DisableStageTransitionRequest): DisableStageTransitionResponse

    /**
     * Enables artifacts in a pipeline to transition to a stage in a pipeline.
     */
    public suspend fun enableStageTransition(input: EnableStageTransitionRequest): EnableStageTransitionResponse

    /**
     * Returns information about an action type created for an external provider, where the action is to be used by customers of the external provider. The action can be created with any supported integration model.
     */
    public suspend fun getActionType(input: GetActionTypeRequest): GetActionTypeResponse

    /**
     * Returns information about a job. Used for custom actions only.
     *
     * When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also returns any secret values defined for the action.
     */
    public suspend fun getJobDetails(input: GetJobDetailsRequest): GetJobDetailsResponse

    /**
     * Returns the metadata, structure, stages, and actions of a pipeline. Can be used to return the entire structure of a pipeline in JSON format, which can then be modified and used to update the pipeline structure with UpdatePipeline.
     */
    public suspend fun getPipeline(input: GetPipelineRequest): GetPipelineResponse

    /**
     * Returns information about an execution of a pipeline, including details about artifacts, the pipeline execution ID, and the name, version, and status of the pipeline.
     */
    public suspend fun getPipelineExecution(input: GetPipelineExecutionRequest): GetPipelineExecutionResponse

    /**
     * Returns information about the state of a pipeline, including the stages and actions.
     *
     * Values returned in the `revisionId` and `revisionUrl` fields indicate the source revision information, such as the commit ID, for the current state.
     */
    public suspend fun getPipelineState(input: GetPipelineStateRequest): GetPipelineStateResponse

    /**
     * Requests the details of a job for a third party action. Used for partner actions only.
     *
     * When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also returns any secret values defined for the action.
     */
    public suspend fun getThirdPartyJobDetails(input: GetThirdPartyJobDetailsRequest): GetThirdPartyJobDetailsResponse

    /**
     * Lists the action executions that have occurred in a pipeline.
     */
    public suspend fun listActionExecutions(input: ListActionExecutionsRequest): ListActionExecutionsResponse

    /**
     * Gets a summary of all AWS CodePipeline action types associated with your account.
     */
    public suspend fun listActionTypes(input: ListActionTypesRequest = ListActionTypesRequest {}): ListActionTypesResponse

    /**
     * Gets a summary of the most recent executions for a pipeline.
     */
    public suspend fun listPipelineExecutions(input: ListPipelineExecutionsRequest): ListPipelineExecutionsResponse

    /**
     * Gets a summary of all of the pipelines associated with your account.
     */
    public suspend fun listPipelines(input: ListPipelinesRequest = ListPipelinesRequest {}): ListPipelinesResponse

    /**
     * Gets the set of key-value pairs (metadata) that are used to manage the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Gets a listing of all the webhooks in this AWS Region for this account. The output lists all webhooks and includes the webhook URL and ARN and the configuration for each webhook.
     */
    public suspend fun listWebhooks(input: ListWebhooksRequest = ListWebhooksRequest {}): ListWebhooksResponse

    /**
     * Returns information about any jobs for AWS CodePipeline to act on. `PollForJobs` is valid only for action types with "Custom" in the owner field. If the action type contains "AWS" or "ThirdParty" in the owner field, the `PollForJobs` action returns an error.
     *
     * When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also returns any secret values defined for the action.
     */
    public suspend fun pollForJobs(input: PollForJobsRequest): PollForJobsResponse

    /**
     * Determines whether there are any third party jobs for a job worker to act on. Used for partner actions only.
     *
     * When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts.
     */
    public suspend fun pollForThirdPartyJobs(input: PollForThirdPartyJobsRequest): PollForThirdPartyJobsResponse

    /**
     * Provides information to AWS CodePipeline about new revisions to a source.
     */
    public suspend fun putActionRevision(input: PutActionRevisionRequest): PutActionRevisionResponse

    /**
     * Provides the response to a manual approval request to AWS CodePipeline. Valid responses include Approved and Rejected.
     */
    public suspend fun putApprovalResult(input: PutApprovalResultRequest): PutApprovalResultResponse

    /**
     * Represents the failure of a job as returned to the pipeline by a job worker. Used for custom actions only.
     */
    public suspend fun putJobFailureResult(input: PutJobFailureResultRequest): PutJobFailureResultResponse

    /**
     * Represents the success of a job as returned to the pipeline by a job worker. Used for custom actions only.
     */
    public suspend fun putJobSuccessResult(input: PutJobSuccessResultRequest): PutJobSuccessResultResponse

    /**
     * Represents the failure of a third party job as returned to the pipeline by a job worker. Used for partner actions only.
     */
    public suspend fun putThirdPartyJobFailureResult(input: PutThirdPartyJobFailureResultRequest): PutThirdPartyJobFailureResultResponse

    /**
     * Represents the success of a third party job as returned to the pipeline by a job worker. Used for partner actions only.
     */
    public suspend fun putThirdPartyJobSuccessResult(input: PutThirdPartyJobSuccessResultRequest): PutThirdPartyJobSuccessResultResponse

    /**
     * Defines a webhook and returns a unique webhook URL generated by CodePipeline. This URL can be supplied to third party source hosting providers to call every time there's a code change. When CodePipeline receives a POST request on this URL, the pipeline defined in the webhook is started as long as the POST request satisfied the authentication and filtering requirements supplied when defining the webhook. RegisterWebhookWithThirdParty and DeregisterWebhookWithThirdParty APIs can be used to automatically configure supported third parties to call the generated webhook URL.
     */
    public suspend fun putWebhook(input: PutWebhookRequest): PutWebhookResponse

    /**
     * Configures a connection between the webhook that was created and the external tool with events to be detected.
     */
    public suspend fun registerWebhookWithThirdParty(input: RegisterWebhookWithThirdPartyRequest = RegisterWebhookWithThirdPartyRequest {}): RegisterWebhookWithThirdPartyResponse

    /**
     * Resumes the pipeline execution by retrying the last failed actions in a stage. You can retry a stage immediately if any of the actions in the stage fail. When you retry, all actions that are still in progress continue working, and failed actions are triggered again.
     */
    public suspend fun retryStageExecution(input: RetryStageExecutionRequest): RetryStageExecutionResponse

    /**
     * Starts the specified pipeline. Specifically, it begins processing the latest commit to the source location specified as part of the pipeline.
     */
    public suspend fun startPipelineExecution(input: StartPipelineExecutionRequest): StartPipelineExecutionResponse

    /**
     * Stops the specified pipeline execution. You choose to either stop the pipeline execution by completing in-progress actions without starting subsequent actions, or by abandoning in-progress actions. While completing or abandoning in-progress actions, the pipeline execution is in a `Stopping` state. After all in-progress actions are completed or abandoned, the pipeline execution is in a `Stopped` state.
     */
    public suspend fun stopPipelineExecution(input: StopPipelineExecutionRequest): StopPipelineExecutionResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from an AWS resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an action type that was created with any supported integration model, where the action type is to be used by customers of the action type provider. Use a JSON file with the action definition and `UpdateActionType` to provide the full structure.
     */
    public suspend fun updateActionType(input: UpdateActionTypeRequest): UpdateActionTypeResponse

    /**
     * Updates a specified pipeline with edits or changes to its structure. Use a JSON file with the pipeline structure and `UpdatePipeline` to provide the full structure of the pipeline. Updating the pipeline increases the version number of the pipeline by 1.
     */
    public suspend fun updatePipeline(input: UpdatePipelineRequest): UpdatePipelineResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CodePipelineClient.withConfig(block: CodePipelineClient.Config.Builder.() -> Unit): CodePipelineClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCodePipelineClient(newConfig)
}

/**
 * Returns information about a specified job and whether that job has been received by the job worker. Used for custom actions only.
 */
public suspend inline fun CodePipelineClient.acknowledgeJob(crossinline block: AcknowledgeJobRequest.Builder.() -> Unit): AcknowledgeJobResponse = acknowledgeJob(AcknowledgeJobRequest.Builder().apply(block).build())

/**
 * Confirms a job worker has received the specified job. Used for partner actions only.
 */
public suspend inline fun CodePipelineClient.acknowledgeThirdPartyJob(crossinline block: AcknowledgeThirdPartyJobRequest.Builder.() -> Unit): AcknowledgeThirdPartyJobResponse = acknowledgeThirdPartyJob(AcknowledgeThirdPartyJobRequest.Builder().apply(block).build())

/**
 * Creates a new custom action that can be used in all pipelines associated with the AWS account. Only used for custom actions.
 */
public suspend inline fun CodePipelineClient.createCustomActionType(crossinline block: CreateCustomActionTypeRequest.Builder.() -> Unit): CreateCustomActionTypeResponse = createCustomActionType(CreateCustomActionTypeRequest.Builder().apply(block).build())

/**
 * Creates a pipeline.
 *
 * In the pipeline structure, you must include either `artifactStore` or `artifactStores` in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use `artifactStores`.
 */
public suspend inline fun CodePipelineClient.createPipeline(crossinline block: CreatePipelineRequest.Builder.() -> Unit): CreatePipelineResponse = createPipeline(CreatePipelineRequest.Builder().apply(block).build())

/**
 * Marks a custom action as deleted. `PollForJobs` for the custom action fails after the action is marked for deletion. Used for custom actions only.
 *
 * To re-create a custom action after it has been deleted you must use a string in the version field that has never been used before. This string can be an incremented version number, for example. To restore a deleted custom action, use a JSON file that is identical to the deleted action, including the original string in the version field.
 */
public suspend inline fun CodePipelineClient.deleteCustomActionType(crossinline block: DeleteCustomActionTypeRequest.Builder.() -> Unit): DeleteCustomActionTypeResponse = deleteCustomActionType(DeleteCustomActionTypeRequest.Builder().apply(block).build())

/**
 * Deletes the specified pipeline.
 */
public suspend inline fun CodePipelineClient.deletePipeline(crossinline block: DeletePipelineRequest.Builder.() -> Unit): DeletePipelineResponse = deletePipeline(DeletePipelineRequest.Builder().apply(block).build())

/**
 * Deletes a previously created webhook by name. Deleting the webhook stops AWS CodePipeline from starting a pipeline every time an external event occurs. The API returns successfully when trying to delete a webhook that is already deleted. If a deleted webhook is re-created by calling PutWebhook with the same name, it will have a different URL.
 */
public suspend inline fun CodePipelineClient.deleteWebhook(crossinline block: DeleteWebhookRequest.Builder.() -> Unit): DeleteWebhookResponse = deleteWebhook(DeleteWebhookRequest.Builder().apply(block).build())

/**
 * Removes the connection between the webhook that was created by CodePipeline and the external tool with events to be detected. Currently supported only for webhooks that target an action type of GitHub.
 */
public suspend inline fun CodePipelineClient.deregisterWebhookWithThirdParty(crossinline block: DeregisterWebhookWithThirdPartyRequest.Builder.() -> Unit): DeregisterWebhookWithThirdPartyResponse = deregisterWebhookWithThirdParty(DeregisterWebhookWithThirdPartyRequest.Builder().apply(block).build())

/**
 * Prevents artifacts in a pipeline from transitioning to the next stage in the pipeline.
 */
public suspend inline fun CodePipelineClient.disableStageTransition(crossinline block: DisableStageTransitionRequest.Builder.() -> Unit): DisableStageTransitionResponse = disableStageTransition(DisableStageTransitionRequest.Builder().apply(block).build())

/**
 * Enables artifacts in a pipeline to transition to a stage in a pipeline.
 */
public suspend inline fun CodePipelineClient.enableStageTransition(crossinline block: EnableStageTransitionRequest.Builder.() -> Unit): EnableStageTransitionResponse = enableStageTransition(EnableStageTransitionRequest.Builder().apply(block).build())

/**
 * Returns information about an action type created for an external provider, where the action is to be used by customers of the external provider. The action can be created with any supported integration model.
 */
public suspend inline fun CodePipelineClient.getActionType(crossinline block: GetActionTypeRequest.Builder.() -> Unit): GetActionTypeResponse = getActionType(GetActionTypeRequest.Builder().apply(block).build())

/**
 * Returns information about a job. Used for custom actions only.
 *
 * When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also returns any secret values defined for the action.
 */
public suspend inline fun CodePipelineClient.getJobDetails(crossinline block: GetJobDetailsRequest.Builder.() -> Unit): GetJobDetailsResponse = getJobDetails(GetJobDetailsRequest.Builder().apply(block).build())

/**
 * Returns the metadata, structure, stages, and actions of a pipeline. Can be used to return the entire structure of a pipeline in JSON format, which can then be modified and used to update the pipeline structure with UpdatePipeline.
 */
public suspend inline fun CodePipelineClient.getPipeline(crossinline block: GetPipelineRequest.Builder.() -> Unit): GetPipelineResponse = getPipeline(GetPipelineRequest.Builder().apply(block).build())

/**
 * Returns information about an execution of a pipeline, including details about artifacts, the pipeline execution ID, and the name, version, and status of the pipeline.
 */
public suspend inline fun CodePipelineClient.getPipelineExecution(crossinline block: GetPipelineExecutionRequest.Builder.() -> Unit): GetPipelineExecutionResponse = getPipelineExecution(GetPipelineExecutionRequest.Builder().apply(block).build())

/**
 * Returns information about the state of a pipeline, including the stages and actions.
 *
 * Values returned in the `revisionId` and `revisionUrl` fields indicate the source revision information, such as the commit ID, for the current state.
 */
public suspend inline fun CodePipelineClient.getPipelineState(crossinline block: GetPipelineStateRequest.Builder.() -> Unit): GetPipelineStateResponse = getPipelineState(GetPipelineStateRequest.Builder().apply(block).build())

/**
 * Requests the details of a job for a third party action. Used for partner actions only.
 *
 * When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also returns any secret values defined for the action.
 */
public suspend inline fun CodePipelineClient.getThirdPartyJobDetails(crossinline block: GetThirdPartyJobDetailsRequest.Builder.() -> Unit): GetThirdPartyJobDetailsResponse = getThirdPartyJobDetails(GetThirdPartyJobDetailsRequest.Builder().apply(block).build())

/**
 * Lists the action executions that have occurred in a pipeline.
 */
public suspend inline fun CodePipelineClient.listActionExecutions(crossinline block: ListActionExecutionsRequest.Builder.() -> Unit): ListActionExecutionsResponse = listActionExecutions(ListActionExecutionsRequest.Builder().apply(block).build())

/**
 * Gets a summary of all AWS CodePipeline action types associated with your account.
 */
public suspend inline fun CodePipelineClient.listActionTypes(crossinline block: ListActionTypesRequest.Builder.() -> Unit): ListActionTypesResponse = listActionTypes(ListActionTypesRequest.Builder().apply(block).build())

/**
 * Gets a summary of the most recent executions for a pipeline.
 */
public suspend inline fun CodePipelineClient.listPipelineExecutions(crossinline block: ListPipelineExecutionsRequest.Builder.() -> Unit): ListPipelineExecutionsResponse = listPipelineExecutions(ListPipelineExecutionsRequest.Builder().apply(block).build())

/**
 * Gets a summary of all of the pipelines associated with your account.
 */
public suspend inline fun CodePipelineClient.listPipelines(crossinline block: ListPipelinesRequest.Builder.() -> Unit): ListPipelinesResponse = listPipelines(ListPipelinesRequest.Builder().apply(block).build())

/**
 * Gets the set of key-value pairs (metadata) that are used to manage the resource.
 */
public suspend inline fun CodePipelineClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Gets a listing of all the webhooks in this AWS Region for this account. The output lists all webhooks and includes the webhook URL and ARN and the configuration for each webhook.
 */
public suspend inline fun CodePipelineClient.listWebhooks(crossinline block: ListWebhooksRequest.Builder.() -> Unit): ListWebhooksResponse = listWebhooks(ListWebhooksRequest.Builder().apply(block).build())

/**
 * Returns information about any jobs for AWS CodePipeline to act on. `PollForJobs` is valid only for action types with "Custom" in the owner field. If the action type contains "AWS" or "ThirdParty" in the owner field, the `PollForJobs` action returns an error.
 *
 * When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also returns any secret values defined for the action.
 */
public suspend inline fun CodePipelineClient.pollForJobs(crossinline block: PollForJobsRequest.Builder.() -> Unit): PollForJobsResponse = pollForJobs(PollForJobsRequest.Builder().apply(block).build())

/**
 * Determines whether there are any third party jobs for a job worker to act on. Used for partner actions only.
 *
 * When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts.
 */
public suspend inline fun CodePipelineClient.pollForThirdPartyJobs(crossinline block: PollForThirdPartyJobsRequest.Builder.() -> Unit): PollForThirdPartyJobsResponse = pollForThirdPartyJobs(PollForThirdPartyJobsRequest.Builder().apply(block).build())

/**
 * Provides information to AWS CodePipeline about new revisions to a source.
 */
public suspend inline fun CodePipelineClient.putActionRevision(crossinline block: PutActionRevisionRequest.Builder.() -> Unit): PutActionRevisionResponse = putActionRevision(PutActionRevisionRequest.Builder().apply(block).build())

/**
 * Provides the response to a manual approval request to AWS CodePipeline. Valid responses include Approved and Rejected.
 */
public suspend inline fun CodePipelineClient.putApprovalResult(crossinline block: PutApprovalResultRequest.Builder.() -> Unit): PutApprovalResultResponse = putApprovalResult(PutApprovalResultRequest.Builder().apply(block).build())

/**
 * Represents the failure of a job as returned to the pipeline by a job worker. Used for custom actions only.
 */
public suspend inline fun CodePipelineClient.putJobFailureResult(crossinline block: PutJobFailureResultRequest.Builder.() -> Unit): PutJobFailureResultResponse = putJobFailureResult(PutJobFailureResultRequest.Builder().apply(block).build())

/**
 * Represents the success of a job as returned to the pipeline by a job worker. Used for custom actions only.
 */
public suspend inline fun CodePipelineClient.putJobSuccessResult(crossinline block: PutJobSuccessResultRequest.Builder.() -> Unit): PutJobSuccessResultResponse = putJobSuccessResult(PutJobSuccessResultRequest.Builder().apply(block).build())

/**
 * Represents the failure of a third party job as returned to the pipeline by a job worker. Used for partner actions only.
 */
public suspend inline fun CodePipelineClient.putThirdPartyJobFailureResult(crossinline block: PutThirdPartyJobFailureResultRequest.Builder.() -> Unit): PutThirdPartyJobFailureResultResponse = putThirdPartyJobFailureResult(PutThirdPartyJobFailureResultRequest.Builder().apply(block).build())

/**
 * Represents the success of a third party job as returned to the pipeline by a job worker. Used for partner actions only.
 */
public suspend inline fun CodePipelineClient.putThirdPartyJobSuccessResult(crossinline block: PutThirdPartyJobSuccessResultRequest.Builder.() -> Unit): PutThirdPartyJobSuccessResultResponse = putThirdPartyJobSuccessResult(PutThirdPartyJobSuccessResultRequest.Builder().apply(block).build())

/**
 * Defines a webhook and returns a unique webhook URL generated by CodePipeline. This URL can be supplied to third party source hosting providers to call every time there's a code change. When CodePipeline receives a POST request on this URL, the pipeline defined in the webhook is started as long as the POST request satisfied the authentication and filtering requirements supplied when defining the webhook. RegisterWebhookWithThirdParty and DeregisterWebhookWithThirdParty APIs can be used to automatically configure supported third parties to call the generated webhook URL.
 */
public suspend inline fun CodePipelineClient.putWebhook(crossinline block: PutWebhookRequest.Builder.() -> Unit): PutWebhookResponse = putWebhook(PutWebhookRequest.Builder().apply(block).build())

/**
 * Configures a connection between the webhook that was created and the external tool with events to be detected.
 */
public suspend inline fun CodePipelineClient.registerWebhookWithThirdParty(crossinline block: RegisterWebhookWithThirdPartyRequest.Builder.() -> Unit): RegisterWebhookWithThirdPartyResponse = registerWebhookWithThirdParty(RegisterWebhookWithThirdPartyRequest.Builder().apply(block).build())

/**
 * Resumes the pipeline execution by retrying the last failed actions in a stage. You can retry a stage immediately if any of the actions in the stage fail. When you retry, all actions that are still in progress continue working, and failed actions are triggered again.
 */
public suspend inline fun CodePipelineClient.retryStageExecution(crossinline block: RetryStageExecutionRequest.Builder.() -> Unit): RetryStageExecutionResponse = retryStageExecution(RetryStageExecutionRequest.Builder().apply(block).build())

/**
 * Starts the specified pipeline. Specifically, it begins processing the latest commit to the source location specified as part of the pipeline.
 */
public suspend inline fun CodePipelineClient.startPipelineExecution(crossinline block: StartPipelineExecutionRequest.Builder.() -> Unit): StartPipelineExecutionResponse = startPipelineExecution(StartPipelineExecutionRequest.Builder().apply(block).build())

/**
 * Stops the specified pipeline execution. You choose to either stop the pipeline execution by completing in-progress actions without starting subsequent actions, or by abandoning in-progress actions. While completing or abandoning in-progress actions, the pipeline execution is in a `Stopping` state. After all in-progress actions are completed or abandoned, the pipeline execution is in a `Stopped` state.
 */
public suspend inline fun CodePipelineClient.stopPipelineExecution(crossinline block: StopPipelineExecutionRequest.Builder.() -> Unit): StopPipelineExecutionResponse = stopPipelineExecution(StopPipelineExecutionRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
 */
public suspend inline fun CodePipelineClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from an AWS resource.
 */
public suspend inline fun CodePipelineClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an action type that was created with any supported integration model, where the action type is to be used by customers of the action type provider. Use a JSON file with the action definition and `UpdateActionType` to provide the full structure.
 */
public suspend inline fun CodePipelineClient.updateActionType(crossinline block: UpdateActionTypeRequest.Builder.() -> Unit): UpdateActionTypeResponse = updateActionType(UpdateActionTypeRequest.Builder().apply(block).build())

/**
 * Updates a specified pipeline with edits or changes to its structure. Use a JSON file with the pipeline structure and `UpdatePipeline` to provide the full structure of the pipeline. Updating the pipeline increases the version number of the pipeline by 1.
 */
public suspend inline fun CodePipelineClient.updatePipeline(crossinline block: UpdatePipelineRequest.Builder.() -> Unit): UpdatePipelineResponse = updatePipeline(UpdatePipelineRequest.Builder().apply(block).build())
