// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurusecurity.endpoints

import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.net.UrlDecoding
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // For region us-gov-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            useDualStack = true
            useFips = true
            region = "us-gov-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security-fips.us-gov-east-1.api.aws", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = true
            region = "us-gov-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security-fips.us-gov-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            useDualStack = true
            useFips = false
            region = "us-gov-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security.us-gov-east-1.api.aws", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = false
            region = "us-gov-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security.us-gov-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack enabled
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            useDualStack = true
            useFips = true
            region = "cn-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security-fips.cn-north-1.api.amazonwebservices.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack disabled
    @Test
    fun test5() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = true
            region = "cn-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security-fips.cn-north-1.amazonaws.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack enabled
    @Test
    fun test6() = runTest {
        val params = EndpointParameters {
            useDualStack = true
            useFips = false
            region = "cn-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security.cn-north-1.api.amazonwebservices.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack disabled
    @Test
    fun test7() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = false
            region = "cn-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security.cn-north-1.amazonaws.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test8() = runTest {
        val params = EndpointParameters {
            useDualStack = true
            useFips = true
            region = "us-iso-east-1"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("FIPS and DualStack are enabled, but this partition does not support one or both", ex.message)
    }

    // For region us-iso-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test9() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = true
            region = "us-iso-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security-fips.us-iso-east-1.c2s.ic.gov", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test10() = runTest {
        val params = EndpointParameters {
            useDualStack = true
            useFips = false
            region = "us-iso-east-1"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("DualStack is enabled but this partition does not support DualStack", ex.message)
    }

    // For region us-iso-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test11() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = false
            region = "us-iso-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security.us-iso-east-1.c2s.ic.gov", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test12() = runTest {
        val params = EndpointParameters {
            useDualStack = true
            useFips = true
            region = "us-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security-fips.us-east-1.api.aws", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test13() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = true
            region = "us-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security-fips.us-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test14() = runTest {
        val params = EndpointParameters {
            useDualStack = true
            useFips = false
            region = "us-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security.us-east-1.api.aws", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test15() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = false
            region = "us-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security.us-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-isob-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test16() = runTest {
        val params = EndpointParameters {
            useDualStack = true
            useFips = true
            region = "us-isob-east-1"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("FIPS and DualStack are enabled, but this partition does not support one or both", ex.message)
    }

    // For region us-isob-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test17() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = true
            region = "us-isob-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security-fips.us-isob-east-1.sc2s.sgov.gov", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-isob-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test18() = runTest {
        val params = EndpointParameters {
            useDualStack = true
            useFips = false
            region = "us-isob-east-1"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("DualStack is enabled but this partition does not support DualStack", ex.message)
    }

    // For region us-isob-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test19() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = false
            region = "us-isob-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-security.us-isob-east-1.sc2s.sgov.gov", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips disabled and dualstack disabled
    @Test
    fun test20() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = false
            region = "us-east-1"
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips enabled and dualstack disabled
    @Test
    fun test21() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = true
            region = "us-east-1"
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: FIPS and custom endpoint are not supported", ex.message)
    }

    // For custom endpoint with fips disabled and dualstack enabled
    @Test
    fun test22() = runTest {
        val params = EndpointParameters {
            useDualStack = true
            useFips = false
            region = "us-east-1"
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

}
