// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurusecurity.transform

import aws.sdk.kotlin.services.codegurusecurity.model.AnalysisType
import aws.sdk.kotlin.services.codegurusecurity.model.CodeGuruSecurityException
import aws.sdk.kotlin.services.codegurusecurity.model.GetScanResponse
import aws.sdk.kotlin.services.codegurusecurity.model.ScanState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetScanOperationDeserializer: HttpDeserialize<GetScanResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetScanResponse {
        if (!response.status.isSuccess()) {
            throwGetScanError(context, response)
        }
        val builder = GetScanResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetScanOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetScanError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeGuruSecurityException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeGuruSecurityException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetScanOperationBody(builder: GetScanResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANALYSISTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("analysisType"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val NUMBEROFREVISIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("numberOfRevisions"))
    val RUNID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("runId"))
    val SCANNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("scanName"))
    val SCANNAMEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("scanNameArn"))
    val SCANSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("scanState"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANALYSISTYPE_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(NUMBEROFREVISIONS_DESCRIPTOR)
        field(RUNID_DESCRIPTOR)
        field(SCANNAME_DESCRIPTOR)
        field(SCANNAMEARN_DESCRIPTOR)
        field(SCANSTATE_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANALYSISTYPE_DESCRIPTOR.index -> builder.analysisType = deserializeString().let { AnalysisType.fromValue(it) }
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                NUMBEROFREVISIONS_DESCRIPTOR.index -> builder.numberOfRevisions = deserializeLong()
                RUNID_DESCRIPTOR.index -> builder.runId = deserializeString()
                SCANNAME_DESCRIPTOR.index -> builder.scanName = deserializeString()
                SCANNAMEARN_DESCRIPTOR.index -> builder.scanNameArn = deserializeString()
                SCANSTATE_DESCRIPTOR.index -> builder.scanState = deserializeString().let { ScanState.fromValue(it) }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
