// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurusecurity.transform

import aws.sdk.kotlin.services.codegurusecurity.model.CodeGuruSecurityException
import aws.sdk.kotlin.services.codegurusecurity.model.GetMetricsSummaryResponse
import aws.sdk.kotlin.services.codegurusecurity.model.MetricsSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetMetricsSummaryOperationDeserializer: HttpDeserialize<GetMetricsSummaryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMetricsSummaryResponse {
        if (!response.status.isSuccess()) {
            throwGetMetricsSummaryError(context, response)
        }
        val builder = GetMetricsSummaryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMetricsSummaryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetMetricsSummaryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeGuruSecurityException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeGuruSecurityException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMetricsSummaryOperationBody(builder: GetMetricsSummaryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val METRICSSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("metricsSummary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(METRICSSUMMARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                METRICSSUMMARY_DESCRIPTOR.index -> builder.metricsSummary = deserializeMetricsSummaryDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
