// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurusecurity.transform

import aws.sdk.kotlin.services.codegurusecurity.model.CodeGuruSecurityException
import aws.sdk.kotlin.services.codegurusecurity.model.CreateUploadUrlResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class CreateUploadUrlOperationDeserializer: HttpDeserialize<CreateUploadUrlResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateUploadUrlResponse {
        if (!response.status.isSuccess()) {
            throwCreateUploadUrlError(context, response)
        }
        val builder = CreateUploadUrlResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateUploadUrlOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateUploadUrlError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeGuruSecurityException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeGuruSecurityException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateUploadUrlOperationBody(builder: CreateUploadUrlResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CODEARTIFACTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("codeArtifactId"))
    val REQUESTHEADERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestHeaders"))
    val S3URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("s3Url"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CODEARTIFACTID_DESCRIPTOR)
        field(REQUESTHEADERS_DESCRIPTOR)
        field(S3URL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CODEARTIFACTID_DESCRIPTOR.index -> builder.codeArtifactId = deserializeString()
                REQUESTHEADERS_DESCRIPTOR.index -> builder.requestHeaders =
                    deserializer.deserializeMap(REQUESTHEADERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                S3URL_DESCRIPTOR.index -> builder.s3Url = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
