// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurusecurity.paginators

import aws.sdk.kotlin.services.codegurusecurity.CodeGuruSecurityClient
import aws.sdk.kotlin.services.codegurusecurity.model.AccountFindingsMetric
import aws.sdk.kotlin.services.codegurusecurity.model.Finding
import aws.sdk.kotlin.services.codegurusecurity.model.GetFindingsRequest
import aws.sdk.kotlin.services.codegurusecurity.model.GetFindingsResponse
import aws.sdk.kotlin.services.codegurusecurity.model.ListFindingsMetricsRequest
import aws.sdk.kotlin.services.codegurusecurity.model.ListFindingsMetricsResponse
import aws.sdk.kotlin.services.codegurusecurity.model.ListScansRequest
import aws.sdk.kotlin.services.codegurusecurity.model.ListScansResponse
import aws.sdk.kotlin.services.codegurusecurity.model.ScanSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetFindingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFindingsResponse]
 */
public fun CodeGuruSecurityClient.getFindingsPaginated(initialRequest: GetFindingsRequest): Flow<GetFindingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getFindingsPaginated.getFindings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFindingsResponse]
 */
public fun CodeGuruSecurityClient.getFindingsPaginated(block: GetFindingsRequest.Builder.() -> Unit): Flow<GetFindingsResponse> =
    getFindingsPaginated(GetFindingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getFindingsPaginated]
 * to access the nested member [Finding]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Finding]
 */
@JvmName("getFindingsResponseFinding")
public fun Flow<GetFindingsResponse>.findings(): Flow<Finding> =
    transform() { response ->
        response.findings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFindingsMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingsMetricsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsMetricsResponse]
 */
public fun CodeGuruSecurityClient.listFindingsMetricsPaginated(initialRequest: ListFindingsMetricsRequest): Flow<ListFindingsMetricsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingsMetricsPaginated.listFindingsMetrics(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingsMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsMetricsResponse]
 */
public fun CodeGuruSecurityClient.listFindingsMetricsPaginated(block: ListFindingsMetricsRequest.Builder.() -> Unit): Flow<ListFindingsMetricsResponse> =
    listFindingsMetricsPaginated(ListFindingsMetricsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFindingsMetricsPaginated]
 * to access the nested member [AccountFindingsMetric]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountFindingsMetric]
 */
@JvmName("listFindingsMetricsResponseAccountFindingsMetric")
public fun Flow<ListFindingsMetricsResponse>.findingsMetrics(): Flow<AccountFindingsMetric> =
    transform() { response ->
        response.findingsMetrics?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListScansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListScansRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScansResponse]
 */
public fun CodeGuruSecurityClient.listScansPaginated(initialRequest: ListScansRequest): Flow<ListScansResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listScansPaginated.listScans(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListScansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScansResponse]
 */
public fun CodeGuruSecurityClient.listScansPaginated(block: ListScansRequest.Builder.() -> Unit): Flow<ListScansResponse> =
    listScansPaginated(ListScansRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listScansPaginated]
 * to access the nested member [ScanSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScanSummary]
 */
@JvmName("listScansResponseScanSummary")
public fun Flow<ListScansResponse>.summaries(): Flow<ScanSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }
