// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurusecurity.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a finding that was detected in your code.
 */
public class Finding private constructor(builder: Builder) {
    /**
     * The time when the finding was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * A description of the finding.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier for the detector that detected the finding in your code. A detector is a defined rule based on industry standards and AWS best practices.
     */
    public val detectorId: kotlin.String? = builder.detectorId
    /**
     * The name of the detector that identified the security vulnerability in your code.
     */
    public val detectorName: kotlin.String? = builder.detectorName
    /**
     * One or more tags or categorizations that are associated with a detector. These tags are defined by type, programming language, or other classification such as maintainability or consistency.
     */
    public val detectorTags: List<String>? = builder.detectorTags
    /**
     * The identifier for the component that generated a finding such as AWSCodeGuruSecurity or AWSInspector.
     */
    public val generatorId: kotlin.String? = builder.generatorId
    /**
     * The identifier for a finding.
     */
    public val id: kotlin.String? = builder.id
    /**
     * An object that contains the details about how to remediate a finding.
     */
    public val remediation: aws.sdk.kotlin.services.codegurusecurity.model.Remediation? = builder.remediation
    /**
     * The resource where Amazon CodeGuru Security detected a finding.
     */
    public val resource: aws.sdk.kotlin.services.codegurusecurity.model.Resource? = builder.resource
    /**
     * The identifier for the rule that generated the finding.
     */
    public val ruleId: kotlin.String? = builder.ruleId
    /**
     * The severity of the finding.
     */
    public val severity: aws.sdk.kotlin.services.codegurusecurity.model.Severity? = builder.severity
    /**
     * The status of the finding. A finding status can be open or closed.
     */
    public val status: aws.sdk.kotlin.services.codegurusecurity.model.Status? = builder.status
    /**
     * The title of the finding.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The type of finding.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The time when the finding was last updated. Findings are updated when you remediate them or when the finding code location changes.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * An object that describes the detected security vulnerability.
     */
    public val vulnerability: aws.sdk.kotlin.services.codegurusecurity.model.Vulnerability? = builder.vulnerability

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurusecurity.model.Finding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Finding(")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("detectorId=$detectorId,")
        append("detectorName=$detectorName,")
        append("detectorTags=$detectorTags,")
        append("generatorId=$generatorId,")
        append("id=$id,")
        append("remediation=$remediation,")
        append("resource=$resource,")
        append("ruleId=$ruleId,")
        append("severity=$severity,")
        append("status=$status,")
        append("title=$title,")
        append("type=$type,")
        append("updatedAt=$updatedAt,")
        append("vulnerability=$vulnerability")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (detectorId?.hashCode() ?: 0)
        result = 31 * result + (detectorName?.hashCode() ?: 0)
        result = 31 * result + (detectorTags?.hashCode() ?: 0)
        result = 31 * result + (generatorId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (remediation?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (vulnerability?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Finding

        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (detectorId != other.detectorId) return false
        if (detectorName != other.detectorName) return false
        if (detectorTags != other.detectorTags) return false
        if (generatorId != other.generatorId) return false
        if (id != other.id) return false
        if (remediation != other.remediation) return false
        if (resource != other.resource) return false
        if (ruleId != other.ruleId) return false
        if (severity != other.severity) return false
        if (status != other.status) return false
        if (title != other.title) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false
        if (vulnerability != other.vulnerability) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurusecurity.model.Finding = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the finding was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the finding.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier for the detector that detected the finding in your code. A detector is a defined rule based on industry standards and AWS best practices.
         */
        public var detectorId: kotlin.String? = null
        /**
         * The name of the detector that identified the security vulnerability in your code.
         */
        public var detectorName: kotlin.String? = null
        /**
         * One or more tags or categorizations that are associated with a detector. These tags are defined by type, programming language, or other classification such as maintainability or consistency.
         */
        public var detectorTags: List<String>? = null
        /**
         * The identifier for the component that generated a finding such as AWSCodeGuruSecurity or AWSInspector.
         */
        public var generatorId: kotlin.String? = null
        /**
         * The identifier for a finding.
         */
        public var id: kotlin.String? = null
        /**
         * An object that contains the details about how to remediate a finding.
         */
        public var remediation: aws.sdk.kotlin.services.codegurusecurity.model.Remediation? = null
        /**
         * The resource where Amazon CodeGuru Security detected a finding.
         */
        public var resource: aws.sdk.kotlin.services.codegurusecurity.model.Resource? = null
        /**
         * The identifier for the rule that generated the finding.
         */
        public var ruleId: kotlin.String? = null
        /**
         * The severity of the finding.
         */
        public var severity: aws.sdk.kotlin.services.codegurusecurity.model.Severity? = null
        /**
         * The status of the finding. A finding status can be open or closed.
         */
        public var status: aws.sdk.kotlin.services.codegurusecurity.model.Status? = null
        /**
         * The title of the finding.
         */
        public var title: kotlin.String? = null
        /**
         * The type of finding.
         */
        public var type: kotlin.String? = null
        /**
         * The time when the finding was last updated. Findings are updated when you remediate them or when the finding code location changes.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that describes the detected security vulnerability.
         */
        public var vulnerability: aws.sdk.kotlin.services.codegurusecurity.model.Vulnerability? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurusecurity.model.Finding) : this() {
            this.createdAt = x.createdAt
            this.description = x.description
            this.detectorId = x.detectorId
            this.detectorName = x.detectorName
            this.detectorTags = x.detectorTags
            this.generatorId = x.generatorId
            this.id = x.id
            this.remediation = x.remediation
            this.resource = x.resource
            this.ruleId = x.ruleId
            this.severity = x.severity
            this.status = x.status
            this.title = x.title
            this.type = x.type
            this.updatedAt = x.updatedAt
            this.vulnerability = x.vulnerability
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurusecurity.model.Finding = Finding(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurusecurity.model.Remediation] inside the given [block]
         */
        public fun remediation(block: aws.sdk.kotlin.services.codegurusecurity.model.Remediation.Builder.() -> kotlin.Unit) {
            this.remediation = aws.sdk.kotlin.services.codegurusecurity.model.Remediation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurusecurity.model.Resource] inside the given [block]
         */
        public fun resource(block: aws.sdk.kotlin.services.codegurusecurity.model.Resource.Builder.() -> kotlin.Unit) {
            this.resource = aws.sdk.kotlin.services.codegurusecurity.model.Resource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurusecurity.model.Vulnerability] inside the given [block]
         */
        public fun vulnerability(block: aws.sdk.kotlin.services.codegurusecurity.model.Vulnerability.Builder.() -> kotlin.Unit) {
            this.vulnerability = aws.sdk.kotlin.services.codegurusecurity.model.Vulnerability.invoke(block)
        }
    }
}
