// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurusecurity.model



public class CreateScanRequest private constructor(builder: Builder) {
    /**
     * The type of analysis you want CodeGuru Security to perform in the scan, either `Security` or `All`. The `Security` type only generates findings related to security. The `All` type generates both security findings and quality findings. Defaults to `Security` type if missing.
     */
    public val analysisType: aws.sdk.kotlin.services.codegurusecurity.model.AnalysisType? = builder.analysisType
    /**
     * The idempotency token for the request. Amazon CodeGuru Security uses this value to prevent the accidental creation of duplicate scans if there are failures and retries.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier for an input resource used to create a scan.
     */
    public val resourceId: aws.sdk.kotlin.services.codegurusecurity.model.ResourceId? = builder.resourceId
    /**
     * The unique name that CodeGuru Security uses to track revisions across multiple scans of the same resource. Only allowed for a `STANDARD` scan type. If not specified, it will be auto generated.
     */
    public val scanName: kotlin.String? = builder.scanName
    /**
     * The type of scan, either `Standard` or `Express`. Defaults to `Standard` type if missing.
     *
     * `Express` scans run on limited resources and use a limited set of detectors to analyze your code in near-real time. `Standard` scans have standard resource limits and use the full set of detectors to analyze your code.
     */
    public val scanType: aws.sdk.kotlin.services.codegurusecurity.model.ScanType? = builder.scanType
    /**
     * An array of key-value pairs used to tag a scan. A tag is a custom attribute label with two parts:
     * + A tag key. For example, `CostCenter`, `Environment`, or `Secret`. Tag keys are case sensitive.
     * + An optional tag value field. For example, `111122223333`, `Production`, or a team name. Omitting the tag value is the same as using an empty string. Tag values are case sensitive.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurusecurity.model.CreateScanRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateScanRequest(")
        append("analysisType=$analysisType,")
        append("clientToken=$clientToken,")
        append("resourceId=$resourceId,")
        append("scanName=$scanName,")
        append("scanType=$scanType,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisType?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (scanName?.hashCode() ?: 0)
        result = 31 * result + (scanType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateScanRequest

        if (analysisType != other.analysisType) return false
        if (clientToken != other.clientToken) return false
        if (resourceId != other.resourceId) return false
        if (scanName != other.scanName) return false
        if (scanType != other.scanType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurusecurity.model.CreateScanRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of analysis you want CodeGuru Security to perform in the scan, either `Security` or `All`. The `Security` type only generates findings related to security. The `All` type generates both security findings and quality findings. Defaults to `Security` type if missing.
         */
        public var analysisType: aws.sdk.kotlin.services.codegurusecurity.model.AnalysisType? = null
        /**
         * The idempotency token for the request. Amazon CodeGuru Security uses this value to prevent the accidental creation of duplicate scans if there are failures and retries.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The identifier for an input resource used to create a scan.
         */
        public var resourceId: aws.sdk.kotlin.services.codegurusecurity.model.ResourceId? = null
        /**
         * The unique name that CodeGuru Security uses to track revisions across multiple scans of the same resource. Only allowed for a `STANDARD` scan type. If not specified, it will be auto generated.
         */
        public var scanName: kotlin.String? = null
        /**
         * The type of scan, either `Standard` or `Express`. Defaults to `Standard` type if missing.
         *
         * `Express` scans run on limited resources and use a limited set of detectors to analyze your code in near-real time. `Standard` scans have standard resource limits and use the full set of detectors to analyze your code.
         */
        public var scanType: aws.sdk.kotlin.services.codegurusecurity.model.ScanType? = null
        /**
         * An array of key-value pairs used to tag a scan. A tag is a custom attribute label with two parts:
         * + A tag key. For example, `CostCenter`, `Environment`, or `Secret`. Tag keys are case sensitive.
         * + An optional tag value field. For example, `111122223333`, `Production`, or a team name. Omitting the tag value is the same as using an empty string. Tag values are case sensitive.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurusecurity.model.CreateScanRequest) : this() {
            this.analysisType = x.analysisType
            this.clientToken = x.clientToken
            this.resourceId = x.resourceId
            this.scanName = x.scanName
            this.scanType = x.scanType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurusecurity.model.CreateScanRequest = CreateScanRequest(this)
    }
}
