// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurusecurity

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.codegurusecurity.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.codegurusecurity.endpoints.EndpointParameters
import aws.sdk.kotlin.services.codegurusecurity.endpoints.EndpointProvider
import aws.sdk.kotlin.services.codegurusecurity.model.BatchGetFindingsRequest
import aws.sdk.kotlin.services.codegurusecurity.model.BatchGetFindingsResponse
import aws.sdk.kotlin.services.codegurusecurity.model.CreateScanRequest
import aws.sdk.kotlin.services.codegurusecurity.model.CreateScanResponse
import aws.sdk.kotlin.services.codegurusecurity.model.CreateUploadUrlRequest
import aws.sdk.kotlin.services.codegurusecurity.model.CreateUploadUrlResponse
import aws.sdk.kotlin.services.codegurusecurity.model.GetAccountConfigurationRequest
import aws.sdk.kotlin.services.codegurusecurity.model.GetAccountConfigurationResponse
import aws.sdk.kotlin.services.codegurusecurity.model.GetFindingsRequest
import aws.sdk.kotlin.services.codegurusecurity.model.GetFindingsResponse
import aws.sdk.kotlin.services.codegurusecurity.model.GetMetricsSummaryRequest
import aws.sdk.kotlin.services.codegurusecurity.model.GetMetricsSummaryResponse
import aws.sdk.kotlin.services.codegurusecurity.model.GetScanRequest
import aws.sdk.kotlin.services.codegurusecurity.model.GetScanResponse
import aws.sdk.kotlin.services.codegurusecurity.model.ListFindingsMetricsRequest
import aws.sdk.kotlin.services.codegurusecurity.model.ListFindingsMetricsResponse
import aws.sdk.kotlin.services.codegurusecurity.model.ListScansRequest
import aws.sdk.kotlin.services.codegurusecurity.model.ListScansResponse
import aws.sdk.kotlin.services.codegurusecurity.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.codegurusecurity.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.codegurusecurity.model.TagResourceRequest
import aws.sdk.kotlin.services.codegurusecurity.model.TagResourceResponse
import aws.sdk.kotlin.services.codegurusecurity.model.UntagResourceRequest
import aws.sdk.kotlin.services.codegurusecurity.model.UntagResourceResponse
import aws.sdk.kotlin.services.codegurusecurity.model.UpdateAccountConfigurationRequest
import aws.sdk.kotlin.services.codegurusecurity.model.UpdateAccountConfigurationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "CodeGuru Security"
public const val SdkVersion: String = "0.29.0-beta"

/**
 * Amazon CodeGuru Security is in preview release and is subject to change.
 *
 * This section provides documentation for the Amazon CodeGuru Security API operations. CodeGuru Security is a service that uses program analysis and machine learning to detect security policy violations and vulnerabilities, and recommends ways to address these security risks.
 *
 * By proactively detecting and providing recommendations for addressing security risks, CodeGuru Security improves the overall security of your application code. For more information about CodeGuru Security, see the [Amazon CodeGuru Security User Guide](https://docs.aws.amazon.com/codeguru/latest/security-ug/what-is-codeguru-security.html).
 */
public interface CodeGuruSecurityClient : SdkClient {
    /**
     * CodeGuruSecurityClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CodeGuruSecurityClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CodeGuruSecurityClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CodeGuruSecurityClient = DefaultCodeGuruSecurityClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CodeGuru Security"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Returns a list of all requested findings.
     */
    public suspend fun batchGetFindings(input: BatchGetFindingsRequest): BatchGetFindingsResponse

    /**
     * Use to create a scan using code uploaded to an S3 bucket.
     */
    public suspend fun createScan(input: CreateScanRequest): CreateScanResponse

    /**
     * Generates a pre-signed URL and request headers used to upload a code resource.
     *
     * You can upload your code resource to the URL and add the request headers using any HTTP client.
     */
    public suspend fun createUploadUrl(input: CreateUploadUrlRequest): CreateUploadUrlResponse

    /**
     * Use to get account level configuration.
     */
    public suspend fun getAccountConfiguration(input: GetAccountConfigurationRequest = GetAccountConfigurationRequest {}): GetAccountConfigurationResponse

    /**
     * Returns a list of all findings generated by a particular scan.
     */
    public suspend fun getFindings(input: GetFindingsRequest): GetFindingsResponse

    /**
     * Returns top level metrics about an account from a specified date, including number of open findings, the categories with most findings, the scans with most open findings, and scans with most open critical findings.
     */
    public suspend fun getMetricsSummary(input: GetMetricsSummaryRequest): GetMetricsSummaryResponse

    /**
     * Returns details about a scan, including whether or not a scan has completed.
     */
    public suspend fun getScan(input: GetScanRequest): GetScanResponse

    /**
     * Returns metrics about all findings in an account within a specified time range.
     */
    public suspend fun listFindingsMetrics(input: ListFindingsMetricsRequest): ListFindingsMetricsResponse

    /**
     * Returns a list of all the standard scans in an account. Does not return express scans.
     */
    public suspend fun listScans(input: ListScansRequest = ListScansRequest {}): ListScansResponse

    /**
     * Returns a list of all tags associated with a scan.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Use to add one or more tags to an existing scan.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Use to remove one or more tags from an existing scan.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Use to update account-level configuration with an encryption key.
     */
    public suspend fun updateAccountConfiguration(input: UpdateAccountConfigurationRequest): UpdateAccountConfigurationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CodeGuruSecurityClient.withConfig(block: CodeGuruSecurityClient.Config.Builder.() -> Unit): CodeGuruSecurityClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCodeGuruSecurityClient(newConfig)
}

/**
 * Returns a list of all requested findings.
 */
public suspend inline fun CodeGuruSecurityClient.batchGetFindings(crossinline block: BatchGetFindingsRequest.Builder.() -> Unit): BatchGetFindingsResponse = batchGetFindings(BatchGetFindingsRequest.Builder().apply(block).build())

/**
 * Use to create a scan using code uploaded to an S3 bucket.
 */
public suspend inline fun CodeGuruSecurityClient.createScan(crossinline block: CreateScanRequest.Builder.() -> Unit): CreateScanResponse = createScan(CreateScanRequest.Builder().apply(block).build())

/**
 * Generates a pre-signed URL and request headers used to upload a code resource.
 *
 * You can upload your code resource to the URL and add the request headers using any HTTP client.
 */
public suspend inline fun CodeGuruSecurityClient.createUploadUrl(crossinline block: CreateUploadUrlRequest.Builder.() -> Unit): CreateUploadUrlResponse = createUploadUrl(CreateUploadUrlRequest.Builder().apply(block).build())

/**
 * Use to get account level configuration.
 */
public suspend inline fun CodeGuruSecurityClient.getAccountConfiguration(crossinline block: GetAccountConfigurationRequest.Builder.() -> Unit): GetAccountConfigurationResponse = getAccountConfiguration(GetAccountConfigurationRequest.Builder().apply(block).build())

/**
 * Returns a list of all findings generated by a particular scan.
 */
public suspend inline fun CodeGuruSecurityClient.getFindings(crossinline block: GetFindingsRequest.Builder.() -> Unit): GetFindingsResponse = getFindings(GetFindingsRequest.Builder().apply(block).build())

/**
 * Returns top level metrics about an account from a specified date, including number of open findings, the categories with most findings, the scans with most open findings, and scans with most open critical findings.
 */
public suspend inline fun CodeGuruSecurityClient.getMetricsSummary(crossinline block: GetMetricsSummaryRequest.Builder.() -> Unit): GetMetricsSummaryResponse = getMetricsSummary(GetMetricsSummaryRequest.Builder().apply(block).build())

/**
 * Returns details about a scan, including whether or not a scan has completed.
 */
public suspend inline fun CodeGuruSecurityClient.getScan(crossinline block: GetScanRequest.Builder.() -> Unit): GetScanResponse = getScan(GetScanRequest.Builder().apply(block).build())

/**
 * Returns metrics about all findings in an account within a specified time range.
 */
public suspend inline fun CodeGuruSecurityClient.listFindingsMetrics(crossinline block: ListFindingsMetricsRequest.Builder.() -> Unit): ListFindingsMetricsResponse = listFindingsMetrics(ListFindingsMetricsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the standard scans in an account. Does not return express scans.
 */
public suspend inline fun CodeGuruSecurityClient.listScans(crossinline block: ListScansRequest.Builder.() -> Unit): ListScansResponse = listScans(ListScansRequest.Builder().apply(block).build())

/**
 * Returns a list of all tags associated with a scan.
 */
public suspend inline fun CodeGuruSecurityClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Use to add one or more tags to an existing scan.
 */
public suspend inline fun CodeGuruSecurityClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Use to remove one or more tags from an existing scan.
 */
public suspend inline fun CodeGuruSecurityClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Use to update account-level configuration with an encryption key.
 */
public suspend inline fun CodeGuruSecurityClient.updateAccountConfiguration(crossinline block: UpdateAccountConfigurationRequest.Builder.() -> Unit): UpdateAccountConfigurationResponse = updateAccountConfiguration(UpdateAccountConfigurationRequest.Builder().apply(block).build())
